package rozdzial02.observ3;

import java.util.List;
import java.util.Random;
import java.util.concurrent.*;
import java.util.concurrent.Flow.Subscriber;
import java.util.function.Supplier;

public class Szpieg extends SubmissionPublisher<Komunikat> {

    private final ScheduledFuture<?> periodicTask;
    private final ScheduledExecutorService scheduler;
    private int i;
    private Subscriber<? super Komunikat> subscriber;

    Szpieg(Executor executor, int maxBufferCapacity, long period, TimeUnit unit) {
        super(executor, maxBufferCapacity);
        scheduler = new ScheduledThreadPoolExecutor(1);
        periodicTask = scheduler.scheduleAtFixedRate(() -> {
            Komunikat kom = supplier.get();
            System.out.println("komunikat: " + kom + " ...");
            submit(kom);
        }, 0, period, unit);
    }

    @Override
    public void subscribe(Subscriber<? super Komunikat> subscriber) {
        super.subscribe(subscriber);
        this.subscriber = subscriber;
    }

    public void close() {
        System.out.println("zamykanie...");
        List<Subscriber<? super Komunikat>> subscribers = getSubscribers();
        for (Subscriber<? super Komunikat> subscriber : subscribers) {
            System.out.println("Centrala " + subscriber.toString() + " nasłuchuje: " + isSubscribed(subscriber));
        }
        periodicTask.cancel(false);
        scheduler.shutdown();
        super.close();
    }

    final Supplier<? extends Komunikat> supplier = (Supplier<Komunikat>) () -> {
        return new Komunikat(new Random().nextFloat(), new Random().nextFloat(), (new Random(250).nextInt()));
    };

}
