package math.utils;

public class MathUtil {
    private MathUtil() {
    }

    public static int nwd2(int x, int y) {
        if (y == 0) {
            return x;
        }
        while (x != y) {
            if (x > y)
                x -= y;
            else
                y -= x;
        }
        return x;
    }

    public static long nwd2(long x, long y) {
        if (y == 0) {
            return x;
        }
        while (x != y) {
            if (x > y)
                x -= y;
            else
                y -= x;
        }
        return x;
    }

    public static int reverteInt(int liczba) {
        String str1 = String.valueOf(liczba);
        return Integer.parseInt(StringUtil.reverteString(str1));
    }

    //logarytm naturalny z n
    public static double ln(double n) {
        return Math.log(n);
    }

    //logarytm dziesiętny z n
    public static double lg(double n) {
        return Math.log10(n);
    }

    //logarytm dziesiętny z n
    public static double log(double n) {
        return Math.log10(n);
    }

    //logarytm o dowolnej podstawie także o podstawie 10 lub e
    //logarytm z b przy podstawie a
    public static double log(double n, double base) {
        return Math.log(n) / Math.log(base);
    }

    /**
     * funkcja zaokragla podaną liczbę do określonej liczby miejsc po przecinku
     *
     * @param num double - liczba do zaokrąglenia
     * @param dec int - liczba miejsc po przecinku;
     * @return double - zwraca zaokrągloną liczbę
     */
    public static double roundToDecimal(double num, int dec) {
        int multi = (int) Math.pow(10, dec);
        int temp = (int) Math.round(num * multi);
        return (double) temp / multi;
    }

    /**
     * zwraca największy wspólny dzielnik dwóch liczb
     *
     * @param a int - pierwsza liczba
     * @param b int - druga liczba
     * @return int - największy wspólny dzielnik
     */
    public static int nwd(int a, int b) {
        int temp;
        if (b == 0) {
            return a;
        } else {
            temp = nwd(b, a % b);
        }
        return temp;
    }

    /**
     * Podaje losową liczbę z przedziału zamkniętego <min, max>
     *
     * @param min long - najmniejsza wartość
     * @param max long - największa wartość
     * @return long - wylosowana wartość z podanego zakresu, z uwzględniem min i
     * max
     */
    public static long randomInRange(long min, long max) {
        long random = -1;
        if (min > max) {
            System.out.println("pierwsza liczba musi byc mniejsza od drugiej");
        } else {
            random = (long) (Math.floor(Math.random() * (max - min + 1)) + min);
        }
        return random;
    }

    public static int randomInRange(int min, int max) {
        int random = -1;
        if (min > max) {
            System.out.println("pierwsza liczba musi byc mniejsza od drugiej");
        } else {
            random = (int) (Math.floor(Math.random() * (max - min + 1)) + min);
        }
        return random;
    }

    public static int from60(int[] sixty) {
        int sum = 0;
        int len = sixty.length;
        for (int i = 0; i < len; i++) {
            sum += sixty[len - i - 1] * (int) Math.pow(60, i);
        }
        return sum;
    }

    public static int[] to60(int dec) {
        int[] tabl = new int[]{};
        int num = dec;
        while (num > 60) {
            int r = num % 60;
            tabl = ArrayUtil.extendArray(tabl, 0, r);
            num = (num - r) / 60;
        }
        tabl = ArrayUtil.extendArray(tabl, 0, num);
        return tabl;
    }
}
