package rozdzial26;

import javafx.application.Application;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaMarkerEvent;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javafx.stage.Stage;
import javafx.util.Duration;
import javafx.util.Pair;
import rozdzial24.IOUtil;

import java.net.URL;

public class Listing26_07 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            URL url = IOUtil.fileToURL("src/resources/assets/psy1.mp4");
            VBox root = new VBox();
            Label l = new Label("");
            Media media = new Media(url.toString());
            ObservableMap<String, Duration> markers = media.getMarkers();
            markers.put("Suita przy piłce", Duration.ZERO);
            markers.put("Menuet", Duration.seconds(14));
            markers.put("Koniec", Duration.seconds(23));
            MediaPlayer mp = new MediaPlayer(media);
            mp.setAutoPlay(false);
            mp.setOnMarker(new EventHandler<MediaMarkerEvent>() {
                @Override
                public void handle(MediaMarkerEvent e) {
                    Pair<String, Duration> m = e.getMarker();
                    String str = m.getKey() + ", " + m.getValue();
                    l.setText(str);
                    System.out.println(str);
                }
            });
            MediaView mv = new MediaView(mp);
            mv.setFitWidth(320);
            mv.setFitHeight(240);
            Button start = new Button("Start");
            start.setOnAction(e -> mp.play());
            Button pause = new Button("Pauza");
            pause.setOnAction(e -> mp.pause());
            Button stop = new Button("Stop");
            stop.setOnAction(e -> mp.stop());
            HBox hbox = new HBox();
            hbox.getChildren().addAll(start, pause, stop);
            root.getChildren().addAll(l, mv, hbox);
            Scene scene = new Scene(root, 340, 280);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
