package rozdzial13;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.scene.effect.DisplacementMap;
import javafx.scene.effect.FloatMap;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class Listing13_11 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Pane root = new Pane();
            Text text = new Text("Urszula");
            text.setX(220);
            text.setY(100);
            text.setFill(Color.AQUAMARINE);
            text.setFont(Font.font(null, FontWeight.BOLD, 80));
            //mapa
            int w = (int) text.getLayoutBounds().getWidth();
            int h = (int) text.getLayoutBounds().getHeight();
            FloatMap map = new FloatMap(w, h);
            for (int i = 0; i < w; i++) {
                double y = Math.sin(i * Math.PI / 6);
                for (int j = 0; j < h; j++) {
                    map.setSamples(i, j, 0.0f, (float) y);
                }
            }
            //efekt
            DisplacementMap ds = new DisplacementMap();
            ds.setMapData(map);
            text.setEffect(ds);
            //slider 1
            Slider oxslider = new Slider(-10, 10, 0);
            oxslider.setLayoutX(60);
            oxslider.setLayoutY(20);
            oxslider.setMajorTickUnit(5);
            oxslider.setShowTickLabels(true);
            oxslider.setShowTickMarks(true);
            ds.offsetXProperty().bind(oxslider.valueProperty());
            Label oxslabel = new Label("offsetX: ");
            oxslabel.setLabelFor(oxslider);
            oxslabel.setLayoutX(20);
            oxslabel.setLayoutY(20);
            //slider 2
            Slider oyslider = new Slider(-10, 10, 0);
            oyslider.setLayoutX(60);
            oyslider.setLayoutY(60);
            oyslider.setMajorTickUnit(5);
            oyslider.setShowTickLabels(true);
            oyslider.setShowTickMarks(true);
            ds.offsetYProperty().bind(oyslider.valueProperty());
            Label oyslabel = new Label("offsetY: ");
            oyslabel.setLabelFor(oyslider);
            oyslabel.setLayoutX(20);
            oyslabel.setLayoutY(60);
            //slider 3
            Slider cslider = new Slider(-2.0, 2.0, 1);
            cslider.setLayoutX(60);
            cslider.setLayoutY(100);
            cslider.setMajorTickUnit(0.2);
            cslider.setShowTickLabels(true);
            cslider.setShowTickMarks(true);
            ds.scaleXProperty().bind(cslider.valueProperty());
            Label slabel = new Label("scaleX: ");
            slabel.setLabelFor(cslider);
            slabel.setLayoutX(20);
            slabel.setLayoutY(100);
            //slider 4
            Slider rslider = new Slider(-2.0, 2.0, 1);
            rslider.setLayoutX(60);
            rslider.setLayoutY(140);
            rslider.setMajorTickUnit(0.2);
            rslider.setShowTickLabels(true);
            rslider.setShowTickMarks(true);
            ds.scaleYProperty().bind(rslider.valueProperty());
            Label rlabel = new Label("scaleY: ");
            rlabel.setLabelFor(rslider);
            rlabel.setLayoutX(20);
            rlabel.setLayoutY(140);
            ComboBox<Boolean> cbox = new ComboBox<>();
            cbox.getItems().addAll(true, false);
            cbox.setLayoutX(70);
            cbox.setLayoutY(220);
            cbox.setValue(ds.isWrap());
            ds.wrapProperty().bind(cbox.valueProperty());
            Label cb1label = new Label("wrap: ");
            cb1label.setLabelFor(cbox);
            cb1label.setLayoutX(20);
            cb1label.setLayoutY(220);
            //
            root.getChildren().addAll(oxslabel, oxslider, oyslabel, oyslider,
                    cslider, slabel, rlabel, rslider, cb1label, cbox, text);
            Scene scene = new Scene(root, 560, 280);
            stage.setScene(scene);
            stage.setTitle("DisplacementMap");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
