package math.utils;

import java.util.ArrayList;
import java.util.Arrays;

public class ArrayUtil {
    private ArrayUtil() {
    }

    /**
     * dodaje wartosc do tablicy pod wskazanym indeksem
     * rozszuwajac elementy i przedluzajac dlugosc tablicy
     */
    public static int[] extendArray(int[] tabl, int indexInserted, int value) {
        int len = tabl.length;
        int lenNew;
        int[] tablNew;
        //sprawdza czy index miesci sie w tablicy
        if ((indexInserted > len) || (indexInserted < 0)) {
            throw new IndexOutOfBoundsException("index poza tablicą");
        } else {//jesli tak
            //przedluza tablice
            tablNew = extendArray(tabl);
            lenNew = tablNew.length;
            //to przepisuje rekordy za indeksem o 1 w prawo
            //zaczynajac od tylu
            System.arraycopy(tablNew, indexInserted, tablNew, indexInserted + 1, lenNew - 1 - indexInserted);
            tablNew[indexInserted] = value;
        }
        return tablNew;
    }

    public static long[] extendArray(long[] tabl, int indexInserted,
                                     long value) {
        int len = tabl.length;
        int lenNew;
        long[] tablNew;
        //sprawdza czy index miesci sie w tablicy
        if ((indexInserted > len) || (indexInserted < 0)) {
            throw new IndexOutOfBoundsException("index poza tablicą");
        } else {//jesli tak
            //przedluza tablice
            tablNew = extendArray(tabl);
            lenNew = tablNew.length;
            //to przepisuje rekordy za indeksem o 1 w prawo
            //zaczynajac od tylu
            System.arraycopy(tablNew, indexInserted, tablNew, indexInserted + 1, lenNew - 1 - indexInserted);
            tablNew[indexInserted] = value;
        }
        return tablNew;
    }

    /**
     * Przedluza tablice o 1 element
     */
    public static int[] extendArray(int[] tabl) {
        int len = tabl.length;
        return Arrays.copyOf(tabl, len + 1);
    }

    public static long[] extendArray(long[] tabl) {
        int len = tabl.length;
        return Arrays.copyOf(tabl, len + 1);
    }

    /**
     * Drukuje na konsoli w linii tablicę intów ujętą w klamry "[" "]"
     *
     * @param array - tablicza do wydruku
     */
    public static void print(int[] array) {
        System.out.print("[");
        for (int i = 0; i < array.length; i++) {
            if (i == array.length - 1) {
                System.out.print(array[i]);
            } else {
                System.out.print(array[i] + ", ");
            }
        }
        System.out.print("]");
        System.out.println();
    }

    public static void print(byte[] array) {
        System.out.print("[");
        for (int i = 0; i < array.length; i++) {
            if (i == array.length - 1) {
                System.out.print(array[i]);
            } else {
                System.out.print(array[i] + ", ");
            }
        }
        System.out.print("]");
        System.out.println();
    }

    public static void printBack(int[] array) {
        System.out.print("[");
        for (int i = array.length - 1; i >= 0; i--) {
            if (i == 0) {
                System.out.print(array[i]);
            } else {
                System.out.print(array[i] + ", ");
            }
        }
        System.out.print("]");
        System.out.println();
    }

    public static void print(long[] array) {
        System.out.print("[");
        for (int i = 0; i < array.length; i++) {
            if (i == array.length - 1) {
                System.out.print(array[i]);
            } else {
                System.out.print(array[i] + ", ");
            }
        }
        System.out.print("]");
        System.out.println();
    }

    /**
     * Drukuje na konsoli w linii tablicę obiektów ujętą w klamry "["  "]".
     *
     * @param array - tablicz obiektów do wydruku
     */
    public static <T> void print(T[] array) {
        System.out.print("[");
        for (int i = 0; i < array.length; i++) {
            if (i == array.length - 1) {
                System.out.print(array[i]);
            } else {
                System.out.print(array[i] + ", ");
            }
        }
        System.out.print("]");
        System.out.println();
    }

    // drukuje arrayliste z danymi dowolnego typu
    // w przypadku typow numerycznych uzywac typow otoczkowych
    // a nie prostych czyli Double a nie double;
    public static <T> void print(ArrayList<T> array) {
        for (int i = 0; i < array.size(); i++) {
            if (i < array.size() - 1) {
                System.out.print(array.get(i) + ", ");
            } else {
                System.out.print(array.get(i));
            }
        }
    }

    public static int[] clone(int[] array) {
        return Arrays.copyOf(array, array.length);
    }

    /**
     * drukuje wskazaną tablice na konsoli
     *
     * @param plist Object[][] - macierz Obiektow
     */
    public static <T> void print(T[][] plist) {
        for (T[] temp : plist) {
            for (T aTemp : temp) {
                System.out.print(aTemp + " ");
            }
            System.out.print("\n");
        }
    }

    public static <T> void print(int[][] plist) {
        for (int[] temp : plist) {
            for (int aTemp : temp) {
                System.out.print(aTemp + " ");
            }
            System.out.print("\n");
        }
    }

    public static void printEratostenes(boolean[] array) {
        System.out.print("[");
        for (int i = 0; i < array.length; i++) {
            if (array[i]) {
                if (i == 2) {
                    System.out.print(i);
                } else {
                    System.out.print(", " + i);
                }
            }
        }
        System.out.print("]");
        System.out.println();
    }

    //przelicza indeks z [][] na []
    public static int index(int row, int col, int cols) {
        return row * cols + col;
    }

    /**
     * przelicza indeks tablicy lub arraylisty na rzad i kolumne
     * macierzy
     *
     * @param indeks int - indeks tablicy
     * @param cols   - int - liczba kolumn
     * @return int[] tablica intow [0] rząd macierzy, [1] kolumna macierzy
     */
    public static int[] obliczRowCol(int indeks, int cols) {
        int row = indeks / cols;
        int col = indeks % cols;
        return new int[]{row, col};
    }

    /**
     * Zamienia macierz na tablice
     *
     * @param tabl - macierz do przekształcenia
     * @return - zwraca tablicę
     */
    public static int[] twoToOne(int[][] tabl) {
        int row = tabl.length;
        int col = tabl[0].length;
        int len = row * col;
        int[] temp = new int[len];
        int k = 0;
        for (int[] aTabl : tabl) {
            for (int j = 0; j < col; j++) {
                temp[k] = aTabl[j];
                k++;
            }
        }
        return temp;
    }

    /**
     * Zamienia tablicę pojedynczą na macierz
     *
     * @param tabl - tablica do przekształcenia
     * @param cols - liczba kolumn
     * @return zwraca macierz
     */
    public static int[][] oneToTwo(int[] tabl, int cols) {
        int rows = tabl.length / cols;
        int[][] temp = new int[rows][cols];
        for (int i = 0; i < tabl.length; i++) {
            temp[i / cols][i % cols] = tabl[i];
        }
        return temp;
    }
}
