package math.bigs;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;

public class BigsUtil {
    public static final BigInteger ZERO = BigInteger.valueOf(0);
    public static final BigInteger ONE = BigInteger.valueOf(1);
    public static final BigInteger TWO = BigInteger.valueOf(2);

    private BigsUtil() {
    }

    /**
     * Sprawdza równość dwóch liczb BigInteger
     *
     * @param f - pierwsza z porównywanych liczb
     * @param s - druga z porównywanych liczb
     * @return zwraca true jeśli liczby są równe, false w przeciwnym przypadku
     */
    public static boolean rowny(BigInteger f, BigInteger s) {
        return (f.compareTo(s) == 0);
    }

    public static boolean mniejszy(BigInteger f, BigInteger s) {
        return (f.compareTo(s) < 0);
    }

    /**
     * Sprawdza czy pierwszy parametr jest większy od drugiego parametru
     *
     * @param f - pierwsza z porównywanych liczb
     * @param s - druga z porównywanych liczb
     * @return zwraca true jeśli f jest większeod s, false w przeciwnym
     * przypadku (f <= s)
     */
    public static boolean wiekszy(BigInteger f, BigInteger s) {
        return (f.compareTo(s) > 0);
    }

    /**
     * Dzieli a/b.
     *
     * @param a - dzielna
     * @param b - dzielnik
     * @return BigDecimal wynik dzielenia
     */
    public static BigDecimal divide(BigInteger a, BigInteger b, int precision) {
        BigDecimal aa = new BigDecimal(a.toString());
        BigDecimal bb = new BigDecimal(b.toString());
        return aa.divide(bb, new MathContext(precision, RoundingMode.HALF_UP));
    }

    /**
     * Sumuje cyfry w tej liczbie
     *
     * @return zwraca sumę cyfr
     */
    public static long ileCyfr(BigInteger liczba) {
        String str = liczba.toString();
        return str.length();
    }

    /**
     * Sprawdza równość dwóch liczb BigInteger
     *
     * @param f - pierwsza z porównywanych liczb
     * @param s - druga z porównywanych liczb
     * @return zwraca true jeśli liczby są równe, false w przeciwnym przypadku
     */
    public static boolean rowny(BigDecimal f, BigDecimal s) {
        return (f.compareTo(s) == 0);
    }

    public static boolean mniejszy(BigDecimal f, BigDecimal s) {
        return (f.compareTo(s) < 0);
    }

    public static boolean wiekszy(BigDecimal f, BigDecimal s) {
        return (f.compareTo(s) > 0);
    }


}
