package math.fibo;

import math.utils.FrequencyMap;

import java.math.BigInteger;

public class Fibo {
    private BigInteger fibo;
    private long n;

    public Fibo(String wyraz) {
        this.n = -1;
        long nn = -1;
        try {
            nn = Long.parseLong(wyraz);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        n = Math.abs(nn);
        fibo = FiboUtil.fibonacci(n);
    }

    public Fibo(long n) {
        if (n >= 0) {
            this.n = n;
            fibo = FiboUtil.fibonacci(n);
        } else {
            throw new IllegalArgumentException("Niewłaściwa liczba");
        }
    }

    /**
     * oblicza frekwencję cyfr 0 do 9 w danej liczbie Fibonacciego
     *
     * @return 11 elementowa tablica intów.
     * [0] podaje liczbę zer
     * [1] podaje liczbę jedynek
     * itd.
     * [10] liczba cyfr w liczbie (suma [0] do [9])
     */
    public int[] stats() {
        String str = fibo.toString();
        FrequencyMap<String> fm = new FrequencyMap<>();
        int[] tabl = new int[11];
        for (int i = 0; i < str.length(); i++) {
            fm.add(str.substring(i, i + 1));
        }
        for (int j = 0; j < 10; j++) {
            tabl[j] = fm.getFrequency(Integer.toString(j));
        }
        tabl[10] = fm.razem();
        return tabl;
    }

    /**
     * Sumuje cyfry w tej liczbie
     *
     * @return zwraca sumę cyfr
     */
    public BigInteger sumaCyfr() {
        BigInteger bi = new BigInteger("0");
        String str = fibo.toString();
        int len = str.length();
        for (int i = 0; i < len; i++) {
            bi = bi.add(new BigInteger(str.substring(i, i + 1)));
        }
        return bi;
    }

    public static int numSumaCyfr(String str) {
        int sum = 0;
        int len = str.length();
        for (int i = 0; i < len; i++) {
            String temp = str.substring(i, i + 1);
            sum += Integer.parseInt(temp);
            if (sum > 9) {
                String temp1 = String.valueOf(sum);
                int i1 = Integer.parseInt(temp1.substring(0, 1));
                int i2 = Integer.parseInt(temp1.substring(1, 2));
                sum = i1 + i2;
            }
        }
        return sum;
    }

    @Override
    public String toString() {
        return fibo.toString();
    }

    public BigInteger getFibo() {
        return fibo;
    }

    public void setFibo(BigInteger fibo) {
        this.fibo = fibo;
    }

    public long getN() {
        return n;
    }

    public void setN(long n) {
        this.n = n;
    }
}
