package rozdzial21;

import javafx.application.Application;
import javafx.application.Platform;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;

import java.util.Optional;

public class Listing21_15 extends Application {

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            StackPane root = new StackPane();
            Scene scene = new Scene(root, 300, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
        Dialog<Integer> dialog = new Dialog<>();
        ButtonType but1 = ButtonType.OK;
        ButtonType but2 = ButtonType.CANCEL;
        dialog.getDialogPane().getButtonTypes().addAll(but1, but2);
        dialog.setTitle("Dialog");
        dialog.initOwner(stage);
        dialog.setResultConverter(param -> {
            if (param == ButtonType.OK) {
                return 10;
            }
            return 2;
        });
        Platform.runLater(() -> {
            Optional<Integer> response = dialog.showAndWait();
            response.ifPresent(integer -> {
                if (integer == 10) {
                    System.out.println("Kliknąłeś przycisk 'OK'. Otrzymałeś 10 pkt.");
                }
                if (integer == 2) {
                    System.out.println("Kliknąłeś przycisk 'CANCEL'. Otrzymałeś 2 pkt.");
                }
            });
        });
    }
}
