package rozdzial18;

import javafx.application.Application;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class Listing18_20 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            Label label = new Label("Wybierz najładniejszą formę imienia: ");
            ObservableList<String> ol = FXCollections.observableArrayList(
                    "Urszula", "Ula", "Ulka", "Ulessa", "Uleńka");
            ListView<String> lv1 = new ListView<>();
            lv1.setItems(ol);
            lv1.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
            lv1.getSelectionModel().selectRange(2, 4);
            ReadOnlyObjectProperty<String> ind = lv1.getSelectionModel()
                    .selectedItemProperty();
            ind.addListener((observable, oldValue, newValue) -> System.out.println(
                    "Aktualna wartość selected to " + newValue));
            root.getChildren().addAll(label, lv1);
            Scene scene = new Scene(root, 200, 200);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
