package rozdzial12;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;

public class Listing12_01 extends Application {
    private int touchId = -1;
    private double touchx, touchy;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Label label = new Label(
                    "Dotknij prostokąta lub przeciągnij go palcem.");
            label.setLayoutX(10);
            label.setLayoutY(10);
            Rectangle rect = new Rectangle(275, 175, 250, 140);
            rect.setFill(Color.AQUAMARINE);
            Pane root = new Pane();
            root.getChildren().addAll(label, rect);
            rect.setOnTouchPressed(event -> {
                if (touchId == -1) {
                    touchId = event.getTouchPoint().getId();
                    touchx = event.getTouchPoint().getSceneX()
                            - rect.getTranslateX();
                    touchy = event.getTouchPoint().getSceneY()
                            - rect.getTranslateY();
                }
                IPrint2.print(event);
                event.consume();
            });
            rect.setOnTouchReleased(event -> {
                if (event.getTouchPoint().getId() == touchId) {
                    touchId = -1;
                }
                IPrint2.print(event);
                event.consume();
            });
            rect.setOnTouchMoved(event -> {
                if (event.getTouchPoint().getId() == touchId) {
                    rect.setTranslateX(
                            event.getTouchPoint().getSceneX() - touchx);
                    rect.setTranslateY(
                            event.getTouchPoint().getSceneY() - touchy);
                }
                IPrint2.print(event);
                event.consume();
            });
            rect.setOnTouchStationary(event -> {
                IPrint2.print(event);
                event.consume();
            });
            Scene scene = new Scene(root, 800, 600);
            stage.setScene(scene);
            stage.setTitle("Zdarzenia");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
