package dragons.providers;

import java.text.DateFormatSymbols;
import java.text.spi.DateFormatSymbolsProvider;
import java.util.Locale;

public class DragonsDateFormatSymbolsProviderImpl extends DateFormatSymbolsProvider {
    private final static Locale[] locales = new Locale[]{new Locale("gd", "GD"),
            new Locale("pl", "PL"), Locale.US};
    private final String[] eragd = new String[]{"nde", "ode"};
    private final String[] erapl = new String[]{
            "nowa smocza era, stara smocza era"};
    private final String[] eraus = new String[]{"new dragon era",
            "old dragon era"};
    private final String[] ampmgd = new String[]{"agd", "pgd"};
    private final String[] ampmpl = new String[]{"przed południem",
            "po południu"};
    private final String[] ampmus = new String[]{"dgAM", "dgPM"};
    private final String[] monthsgd = new String[]{"Pop", "Uo", "Zotz", "Zec",
            "Yaxkin", "Mol", "Chen", "Zec", "Ceh", "Muan", "Pax", "Kayab",
            "Cumku"};
    private final String[] monthspl = new String[]{"Mata", "Czarne złączenie",
            "Nietoperz", "Czas podlewania", "Nowe Słońce", "Woda",
            "Czarny Deszcz", "Biały Rok", "Czerwony Rok", "Mądry Ptak",
            "Czas siewu", "Zółw", "Spichlerz"};
    private final String[] shortmonthspl = new String[]{"Mata", "Złączenie",
            "Nietoperz", "Podlewanie", "Słońce", "Woda", "Deszcz", "Biały",
            "Czerwony", "Ptak", "Siew", "Zółw", "Spichlerz"};
    private final String[] weekdaysgd = new String[]{"", "Imix", "Ik", "Akbal",
            "Kan", "Chicchan", "Cimi", "Manik"};
    private final String[] weekdayspl = new String[]{"", "Wodny Smok", "Wiatr",
            "Ciemność", "Jaszczurka", "Niebiański Wąż", "Czaszka",
            "Smocza Łapa"};
    private final String[] shortweekdayspl = new String[]{"", "Smok", "Wiatr",
            "Ciemność", "Jaszczurka", "Wąż", "Czaszka", "Łapa"};
    private final String locPatChars = "GyYMLwWDdFEuaHkKhmsSzZX";

    @Override
    public DateFormatSymbols getInstance(Locale locale) {
        DateFormatSymbols dfs = new DateFormatSymbols(
                Locale.getDefault(Locale.Category.FORMAT));
        if (locale.equals(locales[0])) {
            dfs.setEras(eragd);
            dfs.setAmPmStrings(ampmgd);
            dfs.setMonths(monthsgd);
            dfs.setShortMonths(monthsgd);
            dfs.setWeekdays(weekdaysgd);
            dfs.setShortWeekdays(weekdaysgd);
            dfs.setLocalPatternChars(locPatChars);
        } else if (locale.equals(locales[1])) {
            dfs.setEras(erapl);
            dfs.setAmPmStrings(ampmpl);
            dfs.setMonths(monthspl);
            dfs.setShortMonths(shortmonthspl);
            dfs.setWeekdays(weekdayspl);
            dfs.setShortWeekdays(shortweekdayspl);
            dfs.setLocalPatternChars(locPatChars);
        } else if (locale.equals(locales[2])) {
            dfs.setEras(eraus);
            dfs.setAmPmStrings(ampmus);
            dfs.setMonths(monthsgd);
            dfs.setShortMonths(monthsgd);
            dfs.setWeekdays(weekdaysgd);
            dfs.setShortWeekdays(weekdaysgd);
            dfs.setLocalPatternChars(locPatChars);
        }
        return dfs;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return locales;
    }
}
