package dragons.providers;

import java.util.Locale;
import java.util.spi.LocaleNameProvider;

public class DragonLocaleNameProviderImpl extends LocaleNameProvider {
    private final static Locale[] locales = new Locale[]{new Locale("gd", "GD"),
            new Locale("pl", "PL"), Locale.US};

    @Override
    public String getDisplayLanguage(String languageCode, Locale locale) {
        if (languageCode.equals("gd")) {
            if (locale.equals(locales[0])) {
                return "grhym";
            } else if (locale.equals(locales[1])) {
                return "język smoczy";
            } else if (locale.equals(locales[2])) {
                return "dragon language";
            }
        }
        return null;
    }

    @Override
    public String getDisplayCountry(String countryCode, Locale locale) {
        if (locale.equals(locales[0])) {
            return "grhymnp";
        } else if (locale.equals(locales[1])) {
            return "Smocza Jama";
        } else if (locale.equals(locales[2])) {
            return "Dragon's Lair";
        }
        return null;
    }

    @Override
    public String getDisplayVariant(String variant, Locale locale) {
        return null;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return locales;
    }
}
