package rozdzial31;

import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Scene;
import javafx.scene.layout.VBox;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebEvent;
import javafx.scene.web.WebView;
import javafx.stage.Stage;

import java.net.URL;

public class Listing31_10 extends Application {

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            VBox root = new VBox();
            WebView wv = new WebView();
            WebEngine we = wv.getEngine();
            URL url = this.getClass().getClassLoader()
                    .getResource("src/resources/html/resize.html");
            if (url != null) {
                we.load(url.toExternalForm());
            }
            we.setOnResized(new EventHandler<WebEvent<Rectangle2D>>() {
                @Override
                public void handle(WebEvent<Rectangle2D> event) {
                    Rectangle2D r = event.getData();
                    stage.setWidth(r.getWidth());
                    stage.setHeight(r.getHeight());
                }
            });
            root.getChildren().add(wv);
            Scene scene = new Scene(root, 560, 260);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
