package rozdzial28;

import javafx.concurrent.Task;

import java.math.BigInteger;

public class Fibonacci extends Task<BigInteger> {
    private final long n;

    public Fibonacci(long n) {
        this.n = n;
    }

    @Override
    public BigInteger call() throws Exception {
        return fibonacci(this.n);
    }

    public static BigInteger fibonacci(long n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException("Podana liczba musi być >=0");
        }
        BigInteger sum = BigInteger.valueOf(0);
        if (n < 2) {
            return BigInteger.valueOf(n);
        } else {
            BigInteger beflast = BigInteger.valueOf(0);
            BigInteger last = BigInteger.valueOf(1);
            for (long i = 1; i < n; i++) {
                sum = beflast.add(last);
                beflast = last;
                last = sum;
            }
        }
        return sum;
    }

    @Override
    protected void scheduled() {
        super.scheduled();
        System.out.println("Wszystko przygotowane");
    }

    @Override
    protected void running() {
        super.running();
        System.out.println("Obliczenia w toku.");
    }

    @Override
    protected void succeeded() {
        super.succeeded();
        System.out.println("Wykonane!");
    }

    @Override
    protected void cancelled() {
        super.cancelled();
        System.out.println("Zadanie przerwane");
    }

    @Override
    protected void failed() {
        super.failed();
        System.out.println("Nie udało się.");
    }
}
