package rozdzial20;

import javafx.application.Application;
import javafx.concurrent.Task;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;

public class Listing20_15 extends Application {
    private Task<Object> worker;

    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {

            HBox root = new HBox();
            ProgressBar pb = new ProgressBar();
            Button sButton = new Button("Start");
            sButton.setOnAction(event -> {
                sButton.setDisable(true);
                pb.setProgress(0);
                worker = new Task<>() {
                    @Override
                    protected Object call() throws Exception {
                        for (int i = 0; i < 20; i++) {
                            Thread.sleep(200);
                            updateMessage("200 millis");
                            updateProgress(i + 1, 20);
                        }
                        return true;
                    }
                };
                pb.progressProperty().unbind();
                pb.progressProperty().bind(worker.progressProperty());

                worker.messageProperty().addListener((observable, oldValue, newValue) -> System.out.println(newValue));

                new Thread(worker).start();
            });
            root.getChildren().addAll(pb, sButton);
            Scene scene = new Scene(root, 200, 100);
            stage.setScene(scene);
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
}
