package rozdzial10;

import javafx.application.Application;
import javafx.scene.Scene;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Line;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import javafx.stage.Stage;

public class Listing10_10 extends Application {
    public static void main(String[] args) {
        Application.launch(args);
    }

    @Override
    public void start(Stage stage) {
        try {
            Rectangle rect1 = new Rectangle(20, 70, 100, 60);
            LinearGradient lg1 = new LinearGradient(0, 0, 1, 0, true,
                    CycleMethod.NO_CYCLE, new Stop(0, Color.DODGERBLUE),
                    new Stop(1, Color.BLACK));
            rect1.setFill(lg1);
            Line line = new Line(220, 20, 110, 300);
            line.setStroke(Color.CYAN);
            Rectangle rect2 = new Rectangle(20, 70, 100, 60);
            LinearGradient lg2 = new LinearGradient(0, 0, 1, 0, true,
                    CycleMethod.NO_CYCLE, new Stop(0, Color.DODGERBLUE),
                    new Stop(1, Color.BLACK));
            rect2.setFill(lg2);
            double slope = slope(line);
            double angle = Math.atan(slope);
            double dangle = 2 * angle;
            double mxx = Math.cos(dangle);
            double mxy = Math.sin(dangle);
            double myx = Math.sin(dangle);
            double myy = -Math.cos(dangle);
            Transform trans = new Affine(mxx, mxy, 0, myx, myy, 0);
            double b = b(line);
            rect2.getTransforms().add(new Translate(0, b));
            rect2.getTransforms().add(trans);
            rect2.getTransforms().add(new Translate(0, -b));
            Pane root = new Pane();
            root.getChildren().addAll(rect1, line, rect2);
            Scene scene = new Scene(root, 400, 400);
            stage.setScene(scene);
            stage.setTitle("Scena");
            stage.show();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    //Oblicza współczynnik nachylenia linii
    public static double slope(Line line) {
        double x = line.getStartX() - line.getEndX();
        double y = line.getStartY() - line.getEndY();
        if (x != 0) {
            return y / x;
        } else {
            throw new ArithmeticException("Próba dzielena przez zero!");
        }
    }

    public static double b(Line line) {
        double m = slope(line);
        double c = m * line.getStartX() - line.getStartY();
        return -c;
    }
}
