/* $Id$ */
/* Copyright R 2002 George Reese, Imaginet */
package org.dasein.persist;

// Opracowa  George Reese dla potrzeb ksiki:
// Java. Aplikacje bazodanowe. Najlepsze rozwizania: J2EE
// Przenis na bibliotek kodu digital@jwt George Reese


import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Stack;

/**
 * Klasa implementuje mechanizm obsugi puli instrukcji dla tej
 * biblioteki. Algorytm ten w obecnej postaci jest maksymalnie uproszczony.
 * W szczeglnoci, nie zawiera obsugi instrukcji z moliwoci przewijania  * i aktualizacji oraz instrukcje s zapisane w konstrukcji
 * hash na podstawie waciwej instrukcji SQL.
 * <br/>
 * @Data ostatniej modyfikacji $Datte$
 * @wersja $Revision$
 * @autor George Reese
 */
public class StatementPool {
    /**
     * Pula instrukcji powstaa na podstawie kodu SQL.
     */
    private HashMap statements = new HashMap();

    /**
     * Tworzy now pul instrukcji.
     */
    public StatementPool() {
        super();
    }

    /**
     * Sprawdza, czy w puli istnieje instrukcja
     * pasujca okrelonej instrukcji SQL.
     * @parametr sql Kod SQL do dopasowania
     * @zwraca true jeeli w puli nie ma instrukcji
     */
    public boolean contains(String sql) {
        Stack stack;

        if( !statements.containsKey(sql) ) {
            return false;
        }
        stack = (Stack)statements.get(sql);
        return !stack.empty();
    }

    /**
     * Pobiera z puli instrukcj odpowiadajc okrelonemu kodowi SQL.
     * @parametr sql kod SQL, dla ktrego potrzebna jest instrukcja
     * @zwraca instrukcj z puli odpowiadajc kodowi SQL
     */
    public PreparedStatement pop(String sql) {
        Stack stack = (Stack)statements.get(sql);

        return (PreparedStatement)stack.pop();
    }

    /**
     * Zwraca do puli instrukcj odpowiadajc okrelonemu kodowi SQL.
     * @parametr sql kod SQL instrukcji
     * @parametr stmt instrukcja przeznaczona do zwrcenia do puli
     */
    public void push(String sql, PreparedStatement stmt) {
        Stack stack;

        if( statements.containsKey(sql) ) {
            stack = (Stack)statements.get(sql);
        }
        else {
            stack = new Stack();
            statements.put(sql, stack);
        }
        stack.push(stmt);
    }
}
