/* $Id$ */
/* Copyright R 2002 George Reese, Imaginet */
package org.dasein.persist;

// Opracowa  George Reese dla potrzeb ksiki:
// Java. Aplikacje bazodanowe. Najlepsze rozwizania: J2EE
// Przenis na bibliotek kodu digital@jwt George Reese


import java.sql.PreparedStatement;
import java.util.EventObject;

/**
 * Reprezentuje zdarzenie wystpujce w instrukcji preparowanej.
 * Obecnie jedynym wystpujcym zdarzeniem jest zamknicie instrukcji
 * przez aplikacj.
 * <br/>
 * Data ostatniej modyfikacji $Date$
 * @wersja $Revision$
 * @autor George Reese
 */
public class StatementEvent extends EventObject {
    /**
     * Kod SQL dla instrukcji preparowanej.
     */
    private String            sql       = null;

    /**
     * Tworzy nowe zdarzenie dla instrukcji preparowanej      
     * za pomoc okrelonego kodu SQL.
     * @parametr sql kod SQL odpowiadajcy instrukcji preparowanej
     * @parametr stmt sama instrukcja
     */
    public StatementEvent(String sql, PreparedStatement stmt) {
        super(stmt);
        this.sql = sql;
    }

    /**
     * @zwraca kod SQL dla instrukcji preparowanej
     */
    public String getSQL() {
        return sql;
    }

    /**
     * @zwraca rdo zdarzenia sformatowane jako klasa
     * <code>PreparedStatement</code>
     */
    public PreparedStatement getStatement() {
        return (PreparedStatement)getSource();
    }
}
