package org.dasein.gb.jsp;

import java.io.IOException;
import java.util.HashMap;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.dasein.gb.Comment;
import org.dasein.persist.PersistenceException;

public class AddCommentTag extends BodyTagSupport {
    private String error = null;

    public int doEndTag() throws JspException {
        if( getBodyContent() != null ) {
            try {
                getPreviousOut().print(getBodyContent().getString());
            }
            catch( IOException e ) {
                throw new JspException(e.getMessage());
            }
        }
        return EVAL_PAGE;
    }

    static private final String NO_NAME =
        "<p class=\"error\">Naley wprowadzi nazwisko.</p>";

    static private final String NO_COMMENT =
        "<p class=\"error\">Nie wprowadzono komentarza!</p>";

    public int doStartTag() throws JspException {
        try {
            ServletRequest request = pageContext.getRequest();
            String name = request.getParameter(Comment.NAME);
            String email = request.getParameter(Comment.EMAIL);
            String comment = request.getParameter(Comment.COMMENT);
            HashMap data = new HashMap();
            Comment cmt;

            if( name != null ) {
                name = name.trim();
                if( name.length() < 1 ) {
                    name = null;
                }
            }
            if( name == null ) {
                if( error != null ) {
                    pageContext.setAttribute(error, NO_NAME);
                    error = null;
                    return SKIP_BODY;
                }
                else {
                    throw new JspException(NO_NAME);
                }
            }
            data.put(Comment.NAME, name);
            if( email != null ) {
                email = email.trim();
                if( email.length() < 1 ) {
                    email = null;
                }
            }
            data.put(Comment.EMAIL, email);
            if( comment != null ) {
                comment = comment.trim();
                if( comment.length() < 1 ) {
                    comment = null;
                }
            }
            if( comment == null ) {
                if( error != null ) {
                    pageContext.setAttribute(error, NO_COMMENT);
                    error = null;
                    return SKIP_BODY;
                }
                else {
                    throw new JspException(NO_COMMENT);
                }
            }
            data.put(Comment.COMMENT, comment);
            cmt = Comment.create(data);
            pageContext.setAttribute(error, null);
            return EVAL_BODY_TAG;
        }
        catch( PersistenceException e ) {
            if( error != null ) {
                pageContext.setAttribute(error, "<p class=\"error\">" +
                                         e.getMessage() +"</p>");
                error = null;
                return SKIP_BODY;
            }
            else {
                throw new JspException(e.getMessage());
            }
        }
    }

    public void setError(String err) {
        error = err;
    }
}
