package org.dasein.persist;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Stack;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

public abstract class Execution {
    static private HashMap cache = new HashMap();
    
    static public Execution getInstance(Class cls) {
        try {
            Stack stack;
            
            synchronized( cache ) {
                if( !cache.containsKey(cls) ) {
                    return (Execution)cls.newInstance();
                }
                else {
                    stack = (Stack)cache.get(cls);
                }
            }
            synchronized( stack ) {
                if( stack.empty() ) {
                    return (Execution)cls.newInstance();
                }
                else {
                    return (Execution)stack.pop();
                }
            }
        }
        catch( InstantiationException e ) {
            throw new RuntimeException(e.getMessage());
        }
        catch( IllegalAccessException e ) {
            throw new RuntimeException(e.getMessage());
        }
    }
    
    public Connection        connection = null;
    public HashMap           data       = null;
    public ResultSet         results    = null;
    public PreparedStatement statement  = null;

    public void close() {
        Stack stack;

        data = null;
        synchronized( cache ) {
            if( !cache.containsKey(this.getClass()) ) {
                stack = new Stack();
                cache.put(this.getClass(), stack);
            }
            else {
                stack = (Stack)cache.get(this.getClass());
            }
        }
        synchronized( stack ) {
            stack.push(this);
        }
    }

    public HashMap execute() throws PersistenceException {
        return execute(true);
    }
    
    public HashMap execute(boolean cl) throws PersistenceException {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup(getDataSource());
            HashMap res;
            
            connection = ds.getConnection();
            statement = connection.prepareStatement(getStatement());
            res = run();
            if( cl ) {
                close();
            }
            return res;
        }
        catch( NamingException e) {
            throw new PersistenceException(e);
        }
        catch( SQLException e ) {
            throw new PersistenceException(e);
        }
        finally {
            if( results != null ) {
                try { results.close(); }
                catch( SQLException e ) { }
                results = null;
            }
            if( statement != null ) {
                try { statement.close(); }
                catch( SQLException e ) { }
                statement = null;
            }
            if( connection != null ) {
                try { connection.close(); }
                catch( SQLException e ) { }
                connection = null;
            }
            data = null;
        }
    }

    public HashMap execute(HashMap d) throws PersistenceException {
        data = d;
        return execute(true);
    }

    public HashMap execute(HashMap d, boolean cl) throws PersistenceException {
        data = d;
        return execute(cl);
    }
    
    public abstract String getDataSource();

    public abstract String getStatement();

    public abstract HashMap run() throws PersistenceException, SQLException;

    public void setData(HashMap data) {
        this.data = data;
    }
}
