package org.dasein.gb.persist;

import java.sql.SQLException;
import java.util.HashMap;

import org.dasein.gb.Comment;
import org.dasein.persist.Execution;
import org.dasein.persist.PersistenceException;

public class LoadComment extends Execution {
    static public LoadComment getInstance() {
        return (LoadComment)Execution.getInstance(LoadComment.class);
    }
    
    static private final String LOAD =
        "SELECT approved, email, name, comment, created " +
        "FROM Comment " +
        "WHERE Comment.commentID = ?";

    static private final int COMMENT_ID = 1;

    static private final int APPROVED   = 1;
    static private final int EMAIL      = 2;
    static private final int NAME       = 3;
    static private final int COMMENT    = 4;
    static private final int CREATED    = 5;

    public HashMap run() throws PersistenceException, SQLException {
        long id = ((Long)data.get(Comment.COMMENT_ID)).longValue();
        HashMap res = new HashMap();
        String tmp;

        statement.setLong(COMMENT_ID, id);
        results = statement.executeQuery();
        if( !results.next() ) {
            throw new PersistenceException("Nie ma takiego komentarza: " + id);
        }
        tmp = results.getString(APPROVED);
        res.put(Comment.APPROVED,
                new Boolean(tmp.trim().equalsIgnoreCase("T")));
        tmp = results.getString(EMAIL);
        if( results.wasNull() ) {
            res.put(Comment.EMAIL, null);
        }
        else {
            res.put(Comment.EMAIL, tmp.trim());
        }
        res.put(Comment.NAME, results.getString(NAME));
        res.put(Comment.COMMENT, results.getString(COMMENT));
        res.put(Comment.CREATED, results.getDate(CREATED));
        return res;
    }

    public String getDataSource() {
        return "jdbc/kyra";
    }
    
    public String getStatement() {
        return LOAD;
    }
}
