package org.dasein.gb;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

import org.dasein.gb.persist.CommentDAO;
import org.dasein.persist.PersistenceException;
import org.dasein.persist.Sequencer;
import org.dasein.util.Cache;

public class Comment {
    static private final Cache cache = new Cache();

    static public final String APPROVED   = "approved";
    static public final String COMMENT    = "comment";
    static public final String COMMENT_ID = "commentID";
    static public final String CREATED    = "created";
    static public final String EMAIL      = "email";
    static public final String NAME       = "name";
    
     static public Comment create(HashMap data) throws PersistenceException {
        Sequencer seq = Sequencer.getInstance(Comment.COMMENT_ID);
        Comment cmt;
        Long id;

        id = new Long(seq.next());
        data.put(Comment.COMMENT_ID, id);
        CommentDAO.create(data);
        cmt = new Comment(id, data);
        synchronized( cache ) {
            cache.cache(id, cmt);
        }
        return cmt;
    }
    
    static public ArrayList getApproved() throws PersistenceException {
        Iterator results = CommentDAO.getApproved().iterator();
        ArrayList cmts = new ArrayList();
        
        while( results.hasNext() ) {
            Long id = (Long)results.next();
            
            cmts.add(Comment.getComment(id.longValue()));
        }
        return cmts;
    }
    
    static public Comment getComment(long cid) throws PersistenceException {
        Long id = new Long(cid);
        
        synchronized( cache ) {
            Comment cmt = (Comment)cache.get(id);

            if( cmt == null ) {
                HashMap data = CommentDAO.getComment(cid);

                data.put(Comment.COMMENT_ID, id);
                cmt = new Comment(id, data);
                cache.cache(id, cmt);
            }
            return cmt;
        }
    }
    
    static public ArrayList getPending() throws PersistenceException {
        Iterator results = CommentDAO.getPending().iterator();
        ArrayList cmts = new ArrayList();
        
        while( results.hasNext() ) {
            Long id = (Long)results.next();
            
            cmts.add(Comment.getComment(id.longValue()));
        }
        return cmts;
    }
    
    private Boolean approved  = null;
    private String  comment   = null;
    private Long    commentID = null;
    private Date    created   = null;
    private String  email     = null;
    private String  name      = null;

    private Comment(Long cid, HashMap data) {
        super();
        commentID = cid;
        load(data);
    }
    
    public String getComment() {
        return comment;
    }

    public long getCommentID() {
        return commentID.longValue();
    }

    public Date getCreated() {
        return created;
    }
    
    public String getEmail() {
        return email;
    }

    public String getName() {
        return name;
    }

    public boolean isApproved() {
        return approved.booleanValue();
    }

    private void load(HashMap data) {
        approved = (Boolean)data.get(Comment.APPROVED);
        comment = (String)data.get(Comment.COMMENT);
        commentID = (Long)data.get(Comment.COMMENT_ID);
        created = (Date)data.get(Comment.CREATED);
        email = (String)data.get(Comment.EMAIL);
        name = (String)data.get(Comment.NAME);
    }

    public void remove() throws PersistenceException {
        HashMap data = new HashMap();

        data.put(Comment.COMMENT_ID, commentID);
        CommentDAO.remove(data);
        synchronized( cache ) {
            cache.release(commentID);
        }
    }
    
    public void save(HashMap data) throws PersistenceException {
        CommentDAO.save(data);
        load(data);
    }
}
