DROP TABLE IF EXISTS ORA_Rating;

CREATE TABLE ORA_Rating (
    code        CHAR(5)         NOT NULL PRIMARY KEY,
    forChildren CHAR(1)		NOT NULL DEFAULT 'N',
    description TEXT		NOT NULL,
    INDEX ( forChildren )
);

INSERT INTO ORA_Rating VALUES ( 'G', 'Y', 'General Audiences' );
INSERT INTO ORA_Rating VALUES ( 'PG', 'N', 'Parental Guidance' );
INSERT INTO ORA_Rating VALUES ( 'PG-13', 'N', 'Caution for children under 13');
INSERT INTO ORA_Rating VALUES ( 'R', 'N', 'Restricted');
INSERT INTO ORA_Rating VALUES ( 'NC-17', 'N', 'No one under 17.');

DROP TABLE IF EXISTS ORA_Film;

CREATE TABLE ORA_Film (
    filmID    BIGINT UNSIGNED NOT NULL PRIMARY KEY,
    title     VARCHAR(100)    NOT NULL,
    language  CHAR(2)	      NOT NULL,
    ranking   INT	      NOT NULL,
    year      INT	      NOT NULL,
    rating    CHAR(5),
    FOREIGN KEY ( rating ) REFERENCES ORA_Rating ( code ),
    UNIQUE INDEX ( title, year ),
    INDEX ( year ),
    INDEX ( ranking)
);

INSERT INTO ORA_Film VALUES ( 1, 'Dirty Western', 'en', 2, 1991, 'NC-17' );
INSERT INTO ORA_Film VALUES ( 2, 'Another Western', 'en', 3, 1992, NULL );
INSERT INTO ORA_Film VALUES ( 3, 'Kiddie Western', 'en', 3, 1992, 'G' );
INSERT INTO ORA_Film VALUES ( 4, 'Big Horror', 'en', 5, 1992, 'R' );

DROP TABLE IF EXISTS ORA_Genre;

CREATE TABLE ORA_Genre (
    code    CHAR(3)      NOT NULL PRIMARY KEY,
    name    VARCHAR(30)  NOT NULL
);

INSERT INTO ORA_Genre VALUES ( 'COM', 'Comedy' );
INSERT INTO ORA_Genre VALUES ( 'WES', 'Western' );
INSERT INTO ORA_Genre VALUES ( 'HOR', 'Horror' );

DROP TABLE IF EXISTS ORA_FilmGenre;

CREATE TABLE ORA_FilmGenre (
    filmID   BIGINT UNSIGNED NOT NULL,
    genre    CHAR(30)	     NOT NULL,
    PRIMARY KEY ( filmID, genre ),
    FOREIGN KEY ( filmID ) REFERENCES ORA_Film ( filmID ),
    FOREIGN KEY ( genre ) REFERENCES ORA_Genre ( code )
);

INSERT INTO ORA_FilmGenre VALUES ( 1, 'WES' );
INSERT INTO ORA_FilmGenre VALUES ( 2, 'WES' );
INSERT INTO ORA_FilmGenre VALUES ( 3, 'WES' );
INSERT INTO ORA_FilmGenre VALUES ( 4, 'HOR' );

DROP TABLE IF EXISTS ORA_Reviewer;

CREATE TABLE ORA_Reviewer (
    reviewerID      BIGINT UNSIGNED NOT NULL PRIMARY KEY,
    name	    VARCHAR(100)    NOT NULL
);

INSERT INTO ORA_Reviewer VALUES ( 1, 'George Reese' );
