package org.dasein.security;

import java.util.HashMap;
import java.util.Locale;

import org.dasein.persist.PersistenceException;
import org.dasein.util.Cache;

public class SharedUser {
    static public final String AUTHORIZATION = "authorization";
    static public final String EMAIL         = "email";
    static public final String FIRST_NAME    = "firstName";
    static public final String LAST_NAME     = "lastName";
    static public final String LOCALE        = "locale";
    static public final String NICKNAME      = "nickname";
    static public final String USER_ID       = "userID";
    static public final String WEB_PAGE      = "webPage";
    
    static private final Cache cache = new Cache();

    static public SharedUser getUser(String uid) throws PersistenceException {
        synchronized( cache ) {
            SharedUser u = (SharedUser)cache.get(uid);

            if( u == null ) {
                HashMap data = UserDAO.load(uid);

                u = new SharedUser(uid, data);
                cache.cache(uid, u);
            }
            return u;
        }
    }

    private int    authorization = 0;
    private String email         = null;
    private String firstName     = null;
    private String lastName      = null;
    private Locale locale        = null;
    private String nickname      = null;
    private String userID        = null;
    private String webPage       = null;
    
    private SharedUser(String uid, HashMap data) {
        super();
        userID = uid;
        {
            Integer auth = (Integer)data.get(SharedUser.AUTHORIZATION);

            authorization = auth.intValue();
        }
        email = ((String)data.get(SharedUser.EMAIL)).trim();
        firstName = ((String)data.get(SharedUser.FIRST_NAME)).trim();
        lastName = ((String)data.get(SharedUser.LAST_NAME)).trim();
        nickname = ((String)data.get(SharedUser.NICKNAME)).trim();
        webPage = (String)data.get(SharedUser.WEB_PAGE);
        if( webPage != null ) {
            webPage = webPage.trim();
        }
    }

    void authenticate(String pw)
        throws AuthenticationException, PersistenceException  {
        UserDAO.authenticate(userID, pw);
    }

    boolean changePassword(String opw, String npw) throws PersistenceException{
        return UserDAO.changePassword(userID, opw, npw);
    }
    
    public int getAuthorization() {
        return authorization;
    }

    public String getEmail() {
        return email;
    }

    public String getFirstName() {
        return firstName;
    }

    public String getLastName() {
        return lastName;
    }

    public Locale getLocale() {
        return locale;
    }
    
    public String getNickname() {
        return nickname;
    }
    
    public String getUserID() {
        return userID;
    }

    public String getWebPage() {
        return webPage;
    }

    public void logout() {
        UserDAO.logout(userID);
    }
}
