package org.dasein.gb.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;

import org.dasein.gb.Comment;
import org.dasein.persist.PersistenceException;
import org.dasein.security.User;

public class ApproveTag extends BodyTagSupport {
    private String admin = null;
    private String error = null;

    public int doEndTag() throws JspException {
        if( getBodyContent() != null ) {
            try {
                getPreviousOut().print(getBodyContent().getString());
                error = null;
                admin = null;
            }
            catch( IOException e ) {
                throw new JspException(e.getMessage());
            }
        }
        return EVAL_PAGE;
    }

    static private final String NOT_ALLOWED =
        "<p class=\"error\">Brak uprawnie do wykonania tej czynnoci.</p>";

    static private final String NOT_AUTH =
        "<p class=\"error\">Uytkownik nie jest zalogowany.</p>";

    static private final String NO_COMMENT =
        "<p class=\"error\">Usunito jeden z komentarzy.</p>";

    public int doStartTag() throws JspException {
        try {
            ServletRequest request = pageContext.getRequest();
            ArrayList pending = Comment.getPending();
            Iterator it = pending.iterator();

            if( !getAdminUser().isAuthenticated() ) {
                if( error != null ) {
                    pageContext.setAttribute(error, NOT_AUTH);
                    error = null;
                    admin = null;
                    return SKIP_BODY;
                }
                else {
                    throw new JspException(NOT_AUTH);
                }
            }
            if( !getAdminUser().authorize(1) ) {
                if( error != null ) {
                    pageContext.setAttribute(error, NOT_ALLOWED);
                    error = null;
                    admin = null;
                    return SKIP_BODY;
                }
                else {
                    throw new JspException(NOT_ALLOWED);
                }
            }
            while( it.hasNext() ) {
                Comment cmt = (Comment)it.next();
                HashMap data = new HashMap();
                long cid = cmt.getCommentID();
                String decision, comment;

                decision = request.getParameter("" + cid);
                comment = request.getParameter("" + cid + "-" +
                                               Comment.COMMENT);
                if( decision == null ) {
                    continue;
                }
                decision = decision.trim();
                if( decision.equalsIgnoreCase("approve") ) {
                    data.put(Comment.COMMENT_ID, new Long(cid));
                    if( comment != null ) {
                        comment = comment.trim();
                        if( comment.length() < 1 ) {
                            comment = null;
                        }
                    }
                    if( comment == null ) {
                        if( error != null ) {
                            pageContext.setAttribute(error, NO_COMMENT);
                            error = null;
                            admin = null;
                            return SKIP_BODY;
                        }
                        else {
                            throw new JspException(NO_COMMENT);
                        }
                    }
                    data.put(Comment.CREATED, cmt.getCreated());
                    data.put(Comment.COMMENT, comment);
                    data.put(Comment.APPROVED, new Boolean(true));
                    data.put(Comment.NAME, cmt.getName());
                    data.put(Comment.EMAIL, cmt.getEmail());
                    cmt.save(data);
                }
                else if( decision.equalsIgnoreCase("reject") ) {
                    cmt.remove();
                }
            }
            pageContext.setAttribute(error, null);
            return EVAL_BODY_TAG;
        }
        catch( PersistenceException e ) {
            if( error != null ) {
                pageContext.setAttribute(error, "<p class=\"error\">" +
                                         e.getMessage() +"</p>");
                error = null;
                admin = null;
                return SKIP_BODY;
            }
            else {
                throw new JspException(e.getMessage());
            }
        }
    }

    public User getAdminUser() throws PersistenceException {
        return (User)pageContext.findAttribute(admin);
    }

    public void setAdmin(String adm) {
        admin = adm;
    }
    
    public void setError(String err) {
        error = err;
    }
} 
