import junit.framework.TestCase;

import com.meterware.httpunit.WebConversation;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;

/**
 * Test logowania lekarza w aplikacji MedRec.
 */
public class PhysicianLoginTest extends TestCase {

  private WebConversation conversation;

  /**
   * Tworzy egzemplarz klasy WebConversation na potrzeby
   * wykonywanego testu.
   */
  protected void setUp() throws Exception {
    super.setUp();

    conversation = new WebConversation();
  }

  /**
   * Sprawdza, czy po prawidowym zalogowaniu lekarza aplikacja zwrci stron wyszukiwania pacjentw.
   */
  public void testPhysicianLogin() throws Exception {
    // Ustanawia poczenie z odpowiedni stron internetow.
    //
    WebResponse response =
      conversation.getResponse("http://localhost:7001/physician/login.do");

    // Sprawdza, czy otwarta strona naley do waciwej aplikacji.
    //
    assertEquals("Avitek Medical Records", response.getTitle());

    // Pobiera formularz logowania.
    //
    WebForm form = response.getFormWithName("userBean");

    // Buduje danie na podstawie formularza.
    // Upewnia si, e formularz zostanie wysany po naciniciu odpowiedniego przycisku.
    //
    WebRequest loginRequest = form.getRequest("action");

    // Wysya prawidow nazw uytkownika i haso.
    //
    loginRequest.setParameter("username", "mary@md.com");
    loginRequest.setParameter("password", "weblogic");

    WebResponse loginResponse = conversation.getResponse(loginRequest);

    // Sprawdza, czy aplikacja rzeczywicie zwrcia oczekiwan stron wyszukiwania pacjentw.
    //
    String destinationPath = loginResponse.getURL().getPath();
    assertTrue(destinationPath.endsWith("search.do"));
  }

} // PhysicianLoginTest
