package stock;

import org.aspectj.lang.reflect.SourceLocation;

/**
 * Aspekt wprowadzajcy mechanizm weryfikacji do systemu kontroli stanu magazynu.
 */
public aspect AuditingAspect {

  // Deklaracja przecicia.
  //
  pointcut auditStockItem() : call(* Warehouse.add(..));

  // Rada wykonywana przed wywoaniem metody add().
  //
  before() : auditStockItem() {
    System.out.println("<--Pocztek wpisu w dzienniku kontrolnym-->");

    // Rejestruje nazw klasy wywoujcej
    //
    SourceLocation sl = thisJoinPoint.getSourceLocation();
    Class myClass = (Class)sl.getWithinType();
    System.out.println("\tKlasa wywoujca: " + myClass.toString());

    // Rejestruje opis towaru dodawanego do magazynu.
    //
    Object[] args = thisJoinPoint.getArgs();
    for(int i=0; i < args.length; ++i) {
      System.out.println("\tDodawany towar: " + args[i]);
    }
  }

  // Rada wykonywana po realizacji wywoania metody add().
  //
  after() : auditStockItem() {
    Warehouse warehouse;
    warehouse = (Warehouse)thisJoinPoint.getTarget();
    System.out.println("\tTowary w magazynie: " + warehouse.itemsInStock());
    System.out.println("<--Koniec wpisu w dzienniku kontrolnym-->");
  }
}
