package pl.helion.j2mepp.bluetooth;

import javax.microedition.midlet.MIDlet;
import javax.microedition.lcdui.*;
public class BluetoothMIDlet extends MIDlet implements CommandListener
{
	public BluetoothMIDlet()
	{
		wybor = new List("Wybierz tryb dzialania",Choice.IMPLICIT,new String[]{"Serwer","Klient"},null);
		Command ok = new Command("OK",Command.OK,0);
		Command koniec = new Command("Koniec",Command.EXIT,0);
		wybor.setSelectCommand(ok);
		wybor.addCommand(koniec);
		wybor.setCommandListener(this);
		serwer = new Form("Serwer dziala...");
		serwer.addCommand(koniec);
		serwer.setCommandListener(this);
		klient = new Form("Podaj tekst:");
		pole = new TextField("Wprowadz tekst:","",150,TextField.ANY);
		klient.append(pole);
		klient.append("");
		klient.addCommand(ok);
		klient.addCommand(koniec);
		ekran = Display.getDisplay(this);
		ekran.setCurrent(wybor);
	}
	public void startApp(){}
	public void pauseApp(){}
	public void destroyApp(boolean u){}
	public void commandAction(Command c, Displayable s)
	{
		if (s == wybor)
		{
			if (c.getCommandType() == Command.OK)
			{
				if (wybor.getSelectedIndex() == 0)
				{
					serwerBT = new SerwerBT(this);
					ekran.setCurrent(serwer);
				}
				if (wybor.getSelectedIndex() == 1)
				{
					klientBT = new KlientBT(this);
					ekran.setCurrent(klient);
				}
			}
			if (c.getCommandType() == Command.EXIT)
				this.notifyDestroyed();
		}
		if (s == serwer)
		{
			serwerBT.koniec();
			this.notifyDestroyed();
		}
		if (s == klient)
		{
			if (c.getCommandType() == Command.EXIT)
				this.notifyDestroyed();
			if (c.getCommandType() == Command.OK)
			{
				String tekst = pole.getString();
				if (!tekst.equals(""))
                                {
					klientBT.wyslij(tekst);
				}
			}
		}
	}
	public void aktywujPolecenia()
	{
		klient.setCommandListener(this);
	}
	public void pokaz(String tekst)
	{
		klient.set(1,new StringItem("",tekst));
	}
	private List wybor;
	private Form serwer;
	private Form klient;
	private TextField pole;
	private SerwerBT serwerBT;
	private KlientBT klientBT;
	private Display ekran;
}
