package pl.helion.j2mepp.odtwarzacz;

import javax.microedition.media.*;
import javax.microedition.media.control.*;
import java.io.*;
import javax.microedition.lcdui.*;

public class Odtwarzacz
{
	public Odtwarzacz(OdtwarzaczMIDlet p_m)
	{	
		m = p_m;
		czytnik = new CzytnikDanych(p_m);
		typZdjecia = this.pobierzDomyslnyTyp();
	}
	public boolean odtwarzaj()
	{
		Item it = null;
		if (tryb && p!=null && p.getState() == Player.REALIZED)
		{
			vc = (VideoControl)p.getControl("VideoControl");
			if (vc!=null)
			{
				it = (Item)vc.initDisplayMode(VideoControl.USE_GUI_PRIMITIVE,null);
			}
		}
		if (p!=null && p.getState() == Player.REALIZED)
		{
			try
			{
				m.wlaczWyswietlacz(it);
				p.prefetch();
				p.start();
				return true;
			}
			catch (MediaException me)
			{
				me.printStackTrace();
			}
			return false;
		} else 
			return false;
	}
	public void przechwyc(boolean czyStart)
	{
		try
		{
			if (czyStart)
			{
				if (!nagrywa)
					new Thread(new Runnable(){ 
						public void run()
						{
							try
							{
								baos = new ByteArrayOutputStream();
								p = Manager.createPlayer("capture://audio");
								p.realize();
								rc = (RecordControl)p.getControl("RecordControl");
								rc.setRecordStream(baos);
								rc.startRecord();
								p.start();
								nagrywa = true;
							} catch (Exception e){}
						}
					}).start();
			} else
			{
				if (nagrywa)
				{
					nagrywa = false;
					rc.commit();
					p.close();
					bufor = baos.toByteArray();
				}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	public void odtworzNagranie()
	{
		if (!nagrywa && bufor.length>0)
		{
			try
			{
				p = Manager.createPlayer(new ByteArrayInputStream(bufor),"audio/x-wav");
				p.realize();
				p.prefetch();
				p.start();
			}
			catch (Exception me)
			{
				me.printStackTrace();
			}
		}
	}
	public void zapisz(String nazwa) throws Exception
	{
		if (!nagrywa && bufor.length>0)
		{
			czytnik.zapisz(nazwa,bufor);
			bufor = new byte[0];
		}
	}
	public void zapisz(String nazwa, byte[] dane) throws Exception
	{
		czytnik.zapisz(nazwa,dane);
	}
	public String pobierzDomyslnyTyp()
	{
		String typy = System.getProperty("video.snapshot.encodings");
		if (typy.indexOf("jpeg")>-1)
			return "encoding=jpeg";
		if (typy.indexOf("png")>-1)
			return "encoding=png";
		if (typy.indexOf("gif")>-1)
			return "encoding=gif";
		return null;
	}
	public String typZdjeciaWTypMIME(String typ)
	{
		if (typ.equals("encoding=jpeg"))
			return "image/jpeg";
		if (typ.equals("encoding=png"))
			return "image/png";
		if (typ.equals("encoding=gif"))
			return "image/gif";
		return "";
	}
	public void pobierzZdjecie()throws Exception
	{
		if (aparat != null)
		{
			new Thread(new Runnable(){
				public void run()
				{
					try
					{
						byte[] bufor_zdjecia = aparat.getSnapshot(typZdjecia);
						zapisz(typZdjeciaWTypMIME(typZdjecia),bufor_zdjecia);
					}
					catch (Exception e)
					{
						e.printStackTrace();
					}
				}
			}).start();
		} 
	}
	public String[] pobierzID()
	{
		return czytnik.pobierzID();
	}
	public void koniec()
	{
		try
		{
			czytnik.koniec();
			if (p!=null && p.getState()!=Player.CLOSED)
			{
				p.close();
				p.deallocate();
			}
		} catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	public Item pobierajObraz()
	{
		Item obrazAparatu = null;
		try
		{
			p = Manager.createPlayer("capture://video");
			p.realize();
			aparat = (VideoControl)p.getControl("VideoControl");
			if (aparat != null)
			{
				obrazAparatu = (Item)aparat.initDisplayMode(VideoControl.USE_GUI_PRIMITIVE,null);
			}
			p.start();
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return obrazAparatu;
	}
	public boolean jestObrazek(String nazwa)
	{
		return (nazwa.startsWith("image"));
	}
	public void przerwij()
	{
		if (p!=null && p.getState() == Player.STARTED)
		{
			try
			{
				p.stop();
				p.close();
				aparat = null;
			} catch (MediaException me)
			{
				me.printStackTrace();
			}
		}
	}
	public void przygotuj(String p_sciezka)
	{
		sciezka = p_sciezka;
		new Thread(new Runnable(){	
			public void run()
			{
				try
				{
					p = czytnik.analizuj(sciezka);
					if (p!=null)
					{	
						p.realize();
						if (p.getContentType().equals("video/mpeg"))
							tryb = true;
						else
							tryb = false;
						odtwarzaj();
					} else
					if (jestObrazek(czytnik.getTyp()))
					{
						Image obraz = Image.createImage(czytnik.getStrumien());
						ImageItem it = new ImageItem("",obraz,ImageItem.LAYOUT_CENTER,"");
						m.wlaczWyswietlacz(it);
					}
				}
				catch (Exception e)
				{
					e.printStackTrace();
				}
			}
		}).start();
	}
	private Player p;
	private OdtwarzaczMIDlet m;
	private VideoControl vc;
	private VideoControl aparat;
	private RecordControl rc;
	private ByteArrayOutputStream baos;
	private String sciezka;
	private CzytnikDanych czytnik;
	private byte[] bufor = new byte[0];
	private boolean tryb;
	private boolean nagrywa = false;
	private String typZdjecia;
}