package pl.helion.j2mepp.odtwarzacz;

import java.io.*;
import javax.microedition.io.*;
import javax.microedition.io.file.*;
import javax.microedition.rms.*;
import javax.microedition.media.*;

public class CzytnikDanych 
{
	public CzytnikDanych(OdtwarzaczMIDlet p_m)
	{
		m = p_m;
		try
		{
			zbior = RecordStore.openRecordStore("media",true);
		} catch (Exception e){}
	}
	public void zapisz(String nazwa, byte[] bufor)
	{
		try
		{
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			DataOutputStream out = new DataOutputStream(baos);
			out.writeUTF(nazwa);
			out.write(bufor);
			byte[] dane = baos.toByteArray();
			zbior.addRecord(dane,0,dane.length);
		} catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	public void koniec()
	{
		try
		{
			zbior.closeRecordStore();
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
	}
	public String[] pobierzID() 
	{
		String[] wyniki = new String[0];
		try
		{
			wyniki = new String[zbior.getNumRecords()];
			RecordEnumeration prz = zbior.enumerateRecords(null,null,false);
			int i=0;
			while (prz.hasNextElement())
			{
				wyniki[i] = prz.nextRecordId()+"";
				i+=1;
			}
			return wyniki;
		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		return wyniki;
	}
	public String rozszerzenieWTyp(String uri)
	{
		String roz = uri.substring(uri.lastIndexOf('.')+1,uri.length());
		String typ = "";
		if (roz.equals("wav"))
			typ = "audio/x-wav";
		if (roz.equals("mpg"))
			typ = "video/mpeg";
		if (roz.equals("mid"))
			typ = "audio/midi";
		if (roz.equals("jpg"))
			typ = "image/jpeg";
		if (roz.equals("png"))
			typ = "image/png";
		if (roz.equals("gif"))
			typ = "image/gif";
		return typ;
	}
	public Player analizuj(String uri)
	{
		Player p = null;
		try
		{
			String protokol = uri.substring(0,4);
			if (protokol.equals("http"))
			{
				HttpConnection pol = (HttpConnection)Connector.open(uri);
				typ = this.rozszerzenieWTyp(uri);
				if (typ.startsWith("image"))
					strumien = pol.openInputStream();
				else
					p = Manager.createPlayer(uri);
			}
			if (protokol.equals("file"))
			{
				String v = System.getProperty("microedition.io.file.FileConnection.version" );
				if (v!=null)
				{
					typ = this.rozszerzenieWTyp(uri);
					if (typ.startsWith("image"))
					{
						FileConnection ic = (FileConnection)Connector.open(uri,Connector.READ);
						strumien = ic.openInputStream();
					} else
						p = Manager.createPlayer(uri);
				}
			}
			if (protokol.equals(" rms"))
			{
				String ID = uri.substring(uri.lastIndexOf('/')+1,uri.length());
				byte[] bufor = zbior.getRecord(Integer.parseInt(ID));
				DataInputStream in = new DataInputStream(new ByteArrayInputStream(bufor));
				typ = in.readUTF();
				int dlugosc = bufor.length - typ.length();
				byte[] dane = new byte[dlugosc];
				in.read(dane);
				strumien = new ByteArrayInputStream(dane);
				if (!typ.startsWith("image"))
					p = Manager.createPlayer(strumien, typ);
			}
		} catch (Exception e)
		{
			e.printStackTrace();
			m.destroyApp(true);
			m.notifyDestroyed();
		}
		return p;
	}
	public InputStream getStrumien()
	{
		return strumien;
	}
	public String getTyp()
	{
		return typ;
	}
	private String typ;
	private InputStream strumien;
	private RecordStore zbior;
	private OdtwarzaczMIDlet m;
}
