package pl.helion.j2mepp.lokalizator.komunikacja;

import java.rmi.RemoteException;
import javax.microedition.location.Coordinates;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationException;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;
import pl.helion.j2mepp.lokalizator.ws.klient.LokalizatorWSService;
import pl.helion.j2mepp.lokalizator.ws.klient.LokalizatorWSService_Stub;


public class WebServiceMenedzerUzytkownikow implements MenedzerUzytkownikow {
    private LokalizatorWSService usluga = new LokalizatorWSService_Stub();
    private String SID = null;
    private static int TIMEOUT = 5;
 
    public boolean zaloguj(String login, String haslo) {
        try { 
            this.SID = usluga.zaloguj(login, haslo);
        }
        catch (Exception e) {e.printStackTrace();}
        return this.SID != null;
    }
    public boolean zarejestruj(String login, String haslo, String imie, String nazwisko) {
        boolean wynik = false;
        try {
            wynik = usluga.zarejestruj(login, haslo, imie, nazwisko);
        }
        catch (Exception e) {e.printStackTrace();}
        return wynik;
    }

    private LocationProvider lp;
    private Location aktualnaPozycja;

    public void init() {
        try {
            this.lp = LocationProvider.getInstance(null);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }
    public boolean dodajUzytkownika(String login) {
        if (this.SID != null) {
            try
            {
                return this.usluga.dodajUzytkownika(this.SID, login);
            } catch (RemoteException re) {
                re.printStackTrace();
                return false;
            }
        }
        else
            return false;
    }

    public Uzytkownik znajdzUzytkownika(String login) {
        if (this.SID != null)
            try
            {
                return this.usluga.znajdzUzytkownika(this.SID, login);
            } catch (RemoteException re) {
                re.printStackTrace();
                return null;
            }
        else
            return null;
    }

    public Coordinates pobierzPozycje() throws LocationException, InterruptedException {
        this.aktualnaPozycja = this.lp.getLocation(TIMEOUT);
        if (this.aktualnaPozycja != null)
            return aktualnaPozycja.getQualifiedCoordinates();
        else
            return null;
    }

    public Uzytkownik[] odswiez() {
        try {
            Coordinates c = this.pobierzPozycje();
            if (c != null)
                return this.usluga.odswiez(SID, c.getLatitude(), c.getLongitude());
            else
                return new Uzytkownik[0];
        } catch (Exception re) {
            re.printStackTrace();
        }
        return new Uzytkownik[0];
    }

    public void wyloguj() {
         try {
            this.usluga.wyloguj(this.SID);
        } catch (RemoteException re) {
            re.printStackTrace();
        }
    }
}
