package pl.helion.j2mepp.lokalizator;

import java.util.Timer;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.List;
import pl.helion.j2mepp.lokalizator.dodatkowe.PobieranieZnajomychTimerTask;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;
import pl.helion.j2mepp.lokalizator.komunikacja.MenedzerUzytkownikow;


public class ZnajomiList extends List {
    private Command cmdKoniec = new Command("Koniec", Command.BACK, 1);
    private Command cmdSzczegoly = new Command("Szczegóły", Command.OK, 0);
    private Command cmdSzukaj = new Command("Szukaj", Command.BACK, 0);

    private Timer zegar = new Timer();

    final int OPOZNIENIE = 1000;
    final int OKRES = 15000;

    private Uzytkownik[] znajomi;

    public ZnajomiList(CommandListener l) {
        super("Lista znajomych", List.EXCLUSIVE);
        this.setSelectCommand(cmdSzczegoly);
        this.setCommandListener(l);
        this.addCommand(cmdKoniec);
        this.addCommand(cmdSzczegoly);
        this.addCommand(cmdSzukaj);
    }

    public void start(MenedzerUzytkownikow mu) {
        PobieranieZnajomychTimerTask pztt = new PobieranieZnajomychTimerTask();
        pztt.setWlasciciel(this);
        pztt.setMenedzerUzytkownikow(mu);
        zegar.schedule(pztt, OPOZNIENIE, OKRES);
    }

    public void odswiezListe(Uzytkownik[] znajomi) {
        this.deleteAll();
        this.znajomi = znajomi;
        for (int i=0;i<znajomi.length;i++) {
            Uzytkownik u = znajomi[i];
            String s = u.getLogin() + " - " + u.getLokalizacja();
            this.append(s, null);
        }
    }

    public Uzytkownik getWybranyUzytkownik() {
        int indeks = this.getSelectedIndex();
        if (indeks > -1)
            return this.znajomi[indeks];
        else
            return null;
    }
}
