package pl.helion.j2mepp.czytnikrss;

import javax.microedition.lcdui.*;
import javax.microedition.midlet.MIDlet;
public class CzytnikRSSMIDlet extends MIDlet implements CommandListener
{	
	public CzytnikRSSMIDlet()
	{
		formawstepna = new Form("Czytnik RSS");
		pole_ilosc = new TextField("Podaj ilosc (0-wszystkie):","0",5,TextField.NUMERIC);
		pole_adres = new TextField("Podaj adres kanalu:","",120,TextField.ANY);
		formawstepna.append(pole_adres);
		formawstepna.append(pole_ilosc);
		Command c = new Command("Wczytaj",Command.OK,0);
		formawstepna.addCommand(c);
		formawstepna.setCommandListener(this);
		lista = new List("Wybierz element",Choice.IMPLICIT);
		formaszczegoly = new Form("Szczegoly");
		Command powrot = new Command("Powrot",Command.EXIT,0);
		formaszczegoly.addCommand(powrot);
		formaszczegoly.setCommandListener(this);
		ekran = Display.getDisplay(this);
		ekran.setCurrent(formawstepna);
		parser = new Parser(this);
	}
	protected void startApp(){}
	protected void pauseApp(){}
	protected void destroyApp(boolean unconditional)
	{
		if (watek!=null)
			watek.zakoncz();
	}
	public void usunItemy(Form formatka)
	{
		for (int i=formatka.size()-1;i>=0;i--)
			formatka.delete(i);
	}
	public void commandAction(Command c, Displayable s)
	{
		if (s == formawstepna)
		{
			if (c.getCommandType() == Command.OK)
			{
				String url = pole_adres.getString();
				if (!url.equals(""))
				{
					ekran.setCurrent(lista);
					watek = new WatekPobierania(url, this, parser);
					watek.start();
				}
			}
		}
		if (s == lista)
		{
			if (c.getCommandType() == Command.ITEM)
			{
				this.usunItemy(formaszczegoly);
				if (c.getPriority() == 0)
				{
					int k = lista.getSelectedIndex();
					Dane d = parser.pobierzElement(k);
					for (int i=0;i<d.ilosc();i++)
						if (d.pobierzElement(i)!=null)
							formaszczegoly.append(d.pobierzNazwe(i)+"\r\n"+d.pobierzElement(i)+"\r\n");
				}
				if (c.getPriority() == 1)
				{
					Dane dane_kanalu = parser.pobierzDaneKanalu();
					for (int i=0;i<dane_kanalu.ilosc();i++)
						if (dane_kanalu.pobierzElement(i)!=null)
							formaszczegoly.append(dane_kanalu.pobierzNazwe(i)+"\r\n"+dane_kanalu.pobierzElement(i)+"\r\n");
				}
				ekran.setCurrent(formaszczegoly);
			}
			if (c.getCommandType() == Command.EXIT)
			{
				this.destroyApp(true);
				this.notifyDestroyed();
			}
		}
		if (s == formaszczegoly)
		{
			ekran.setCurrent(lista);
		}
	}
	public void aktywujListe()
	{
		Command wybierz = new Command("Wybierz",Command.ITEM,0);
		Command info = new Command("Informacje",Command.ITEM,1);
		Command wyjscie = new Command("Koniec",Command.EXIT,0);
		lista.addCommand(wybierz);
		lista.addCommand(info);
		lista.addCommand(wyjscie);
		lista.setSelectCommand(wybierz);
		lista.setCommandListener(this);
	}
	public void pokazBlad(String s)
	{
		Alert a = new Alert("Wystapil blad krytyczny! ");
		a.setString(s);
		a.setTimeout(3000);
		ekran.setCurrent(a);
		try
		{
			Thread.sleep(3000);
		} catch (InterruptedException e){}
		this.destroyApp(true);
		this.notifyDestroyed();
	}
	public void dodajElement(Dane d)
	{
		lista.append(d.pobierzElement("title"),null);
	}
	public int pobierzIlosc()
	{
		return Integer.parseInt(pole_ilosc.getString());
	}
	private Display ekran;
	private Form formawstepna;
	private List lista;
	private Form formaszczegoly;
	private TextField pole_ilosc;
	private TextField pole_adres;
	private Parser parser;
	private WatekPobierania watek;
}
