package pl.helion.j2mepp.bluetooth;

import javax.bluetooth.*;
import javax.microedition.io.*;
import java.io.*;
import java.util.Vector;
public class KlientBT implements Runnable, DiscoveryListener
{
	public KlientBT(BluetoothMIDlet _m)
	{
		m = _m;
		urzadzenia = new Vector();
		IDki = new UUID[2];
		IDki[0] = new UUID(0x1101);
		IDki[1] = UUID_SERWERA;
		atrybuty = new int[1];
		atrybuty[0] = ATRYBUT_WERSJI;
		Thread w = new Thread(this);
		w.start();
	}
	public synchronized void run()
	{
		try
		{
			urzadzenie = LocalDevice.getLocalDevice();
			wyszukiwarka = urzadzenie.getDiscoveryAgent();
			wyszukiwarka.startInquiry(DiscoveryAgent.GIAC,this);
			wait();
			this.szukajUslugi();
			wait();
			m.aktywujPolecenia();
			wait();
			while (true)
			{
				String wartosc = this.wyslij();
				m.pokaz(wartosc);
				wait();
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			m.notifyDestroyed();
		}
	}
	public void deviceDiscovered(RemoteDevice urzadzenie, DeviceClass rodzaj)
	{
		if (urzadzenia.indexOf(urzadzenie)==-1)
			urzadzenia.addElement(urzadzenie);
	}
	public void inquiryCompleted(int rodzaj)
	{
		if (rodzaj == DiscoveryListener.INQUIRY_COMPLETED)
		{
			synchronized(this) 
			{
				notify();
			}
		} else
			m.notifyDestroyed();
	}
	public void servicesDiscovered(int IDtransakcji, ServiceRecord[] uslugi)
	{
		if (usluga == null)
		{
			for (int i=0;i<uslugi.length;i++)
			{
				DataElement de = uslugi[i].getAttributeValue(ATRYBUT_WERSJI);
				long parametr = de.getLong();
				if (parametr==1)
				{
					znalezionoUsluge = true;
					usluga = uslugi[i];
					break;
				}
			}
		}
	}
	public void serviceSearchCompleted(int IDtransakcji, int kod)
	{
		if (znalezionoUsluge && !zakonczono)
		{
			zakonczono = true;
			synchronized(this)
			{
				notify();
			}
		}
	}
	public void szukajUslugi() throws Exception
	{
		for (int i=0;i<urzadzenia.size();i++)
		{
			RemoteDevice urzadzenie = (RemoteDevice)urzadzenia.elementAt(i);
			wyszukiwarka.searchServices(atrybuty,IDki,urzadzenie,this);
		}
	}
	public synchronized void wyslij(String tekst)
	{		
		this.tekst = tekst;
		notify();
	}
    private String wyslij()
    {
    	try
		{
			String url = usluga.getConnectionURL(ServiceRecord.NOAUTHENTICATE_NOENCRYPT,false);
			StreamConnection pol = (StreamConnection)Connector.open(url);
			byte dlugosc = (byte)tekst.length();
			OutputStream wyj = pol.openOutputStream();
			InputStream wej = pol.openInputStream();
			wyj.write(dlugosc);
                        wyj.write(tekst.getBytes("ISO-8859-1"));
			wyj.flush();
			wyj.close();
			int licznik = 0;
			byte[] bufor = new byte[dlugosc];
			while (licznik<dlugosc)
			{
				int liczba = wej.read(bufor,licznik,dlugosc-licznik);
				licznik+=liczba;
			}
			wej.close();
			pol.close();
			return new String(bufor,"ISO-8859-1");
		} catch (Exception e)
		{
			e.printStackTrace();
		}
		return "";
    }
	private BluetoothMIDlet m;
	private LocalDevice urzadzenie;
	private DiscoveryAgent wyszukiwarka;
	private Vector urzadzenia;
	private ServiceRecord usluga = null;
	private UUID[] IDki;
	private int[] atrybuty;
	private String tekst = "";
	private boolean znalezionoUsluge = false;
	private boolean zakonczono = false;
	private static final int ATRYBUT_WERSJI = 0x3232;
	private static final UUID UUID_SERWERA = 
		new UUID("ABCDEF12345678998877665544332211", false);
}
