package pl.helion.j2mepp.zdalnakamera;

import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.TextField;

public class LogowanieForm extends Form implements ItemCommandListener {
    private TextField txtSID = new TextField("Wprowadź SID:", "", 40, TextField.ANY);
    private ChoiceGroup choiceRodzaj = new ChoiceGroup("Rodzaj:", ChoiceGroup.EXCLUSIVE, new String[] { "Nadawca", "Odbiorca" }, null);
    private Command cmdZaloguj = new Command("Zaloguj", Command.OK, 0);
    private Command cmdZmienOpcje = new Command("Zmień opcję", Command.OK, 1);

    public LogowanieForm(CommandListener l) {
        super("Logowanie");
        this.append(choiceRodzaj);
        this.choiceRodzaj.setDefaultCommand(cmdZmienOpcje);
        this.choiceRodzaj.setItemCommandListener(this);
        this.addCommand(cmdZaloguj);
        this.setCommandListener(l);
    }

    public void commandAction(Command c, Item i) {
        int indeks = this.choiceRodzaj.getSelectedIndex();
        if (indeks == 0 && this.get(1) == this.txtSID)
            this.delete(1);
        if (indeks == 1 && this.size() == 1)
            this.append(txtSID);
    }

    public String getSID() {
        return txtSID.getString();
    }

    public boolean isNadawca() {
        return this.choiceRodzaj.isSelected(0);
    }
}