package pl.helion.j2mepp.lokalizator.ws;

import com.rychlickikicior.kitijdb.DBManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import javax.jws.WebMethod;
import javax.jws.WebService;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.helion.j2mepp.lokalizator.bezpieczenstwo.MechanizmBezpieczenstwa;
import pl.helion.j2mepp.lokalizator.bezpieczenstwo.Wpis;
import pl.helion.j2mepp.lokalizator.dto.Powiazanie;
import pl.helion.j2mepp.lokalizator.dto.Uzytkownik;


@WebService()
public class LokalizatorWS {
    private final DBManager menadzer;
    private final MechanizmBezpieczenstwa bezp;

    final String API_KEY = "dj0yJmk9NFR5OU5WUndKSldIJmQ9WVdrOVFXMWxNWEU0TjJNbWNHbzlPVFl5TlRneU1EWXkmcz1jb25zdW1lcnNlY3JldCZ4PTJk";
    final String SHARED_SECRET = "14127cc1bf01d13ce62fe224e5fb136385e25756";
    final String APPLICATION_ID = "Ame1q87c";

    public LokalizatorWS() throws IOException {
        URL url = getClass().getResource("./ustawienia.xml");
        InputStream is = url.openStream();
        menadzer = DBManager.createManager(is);
        bezp = new MechanizmBezpieczenstwa();
    }

    @WebMethod
    public boolean dodajUzytkownika(String SID, String login) {
        Wpis w = bezp.getWpis(SID);
        if (w != null) {
            Uzytkownik ja = w.getUzytkownik();
            Uzytkownik znajomy = this.pobierzUzytkownikaPrzezLogin(login);
            Powiazanie p = new Powiazanie();
            if (ja.getID() < znajomy.getID()) {
                p.setID1(ja.getID());
                p.setID2(znajomy.getID());
            } else {
                p.setID1(znajomy.getID());
                p.setID2(ja.getID());
            }
            menadzer.insert(p);
            return true;
        } else
            return false;
    }

    @WebMethod
    public Uzytkownik znajdzUzytkownika(String SID, String login) {
        Wpis w = bezp.getWpis(SID);
        if (w != null) {
            Uzytkownik u = this.pobierzUzytkownikaPrzezLogin(login);
            return u;
        } else
            return null;
    }

    @WebMethod
    public Uzytkownik[] odswiez(String SID, double szerokosc, double dlugosc) {
        Wpis w = bezp.getWpis(SID);
        if (w != null) {
            Uzytkownik u = w.getUzytkownik();
            u.setSzerokosc(szerokosc);
            u.setDlugosc(dlugosc);
            u.setLokalizacja(this.pobierzLokalizacje(szerokosc, dlugosc));
            menadzer.update(u);
            List<Uzytkownik> znajomiWPoblizu = menadzer.select(Uzytkownik.class, "znajomiWPoblizu", u.getID(), u.getSzerokosc(), u.getDlugosc(), 5000);
            return znajomiWPoblizu.toArray(new Uzytkownik[0]);
        } else
            return new Uzytkownik[0];
    }

    @WebMethod
    public String zaloguj(String login, String haslo) {
        Uzytkownik u = this.pobierzUzytkownikaPrzezLogin(login);
        if (u != null) {
            if (u.getHaslo().equals(haslo)) {
                synchronized(bezp) {
                    String sid = bezp.generujSID();
                    bezp.putWpis(sid, u);
                    return sid;
        }
            } else
                return null;
        } else
            return null;
    }

    @WebMethod
    public boolean zarejestruj(String login, String haslo, String imie, String nazwisko) {
        if (this.pobierzUzytkownikaPrzezLogin(login) != null)
            return false;
        Uzytkownik u = new Uzytkownik();
        u.setDlugosc(0.0);
        u.setSzerokosc(0.0);
        u.setLokalizacja("");
        u.setImie(imie);
        u.setLogin(login);
        u.setNazwisko(nazwisko);
        u.setHaslo(haslo);
        u.setID(null);
        u = (Uzytkownik)menadzer.insert(u);
        return u.getID() != null;
    }

    @WebMethod
    public void wyloguj(String SID) {
        Wpis w = bezp.getWpis(SID);
        if (w != null) {
            Uzytkownik u = w.getUzytkownik();
            this.bezp.usunWpis(SID);
            u.setDlugosc(-10000);
            u.setSzerokosc(-10000);
            u.setLokalizacja("");
            menadzer.update(u);
        }
    }

    private Uzytkownik pobierzUzytkownikaPrzezLogin(String login) {
        List<Uzytkownik> lista = menadzer.select(Uzytkownik.class, "pobierzPrzezLogin", login);
        if (lista.size() > 0) {
            Uzytkownik u = lista.get(0);
            return u;
        } else
            return null;
    }

    private String pobierzLokalizacje(double szerokosc, double dlugosc) {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            String url = String.format("http://where.yahooapis.com/geocode?q=%s, %s&gflags=R&appid=%s", szerokosc, dlugosc, APPLICATION_ID);
            Document dokument = db.parse(url);
            Element e = dokument.getDocumentElement();
            Node resultTag = pobierzPierwszaGalaz(e, "Result");
            Node cityTag = pobierzPierwszaGalaz(resultTag, "city");
            Node countyTag = pobierzPierwszaGalaz(resultTag, "county");
            Node countryTag = pobierzPierwszaGalaz(resultTag, "country");
            String miasto = cityTag.getTextContent();
            String wojewodztwo = countyTag.getTextContent();
            String kraj = countryTag.getTextContent();
            return miasto + ", " + wojewodztwo + ", " + kraj;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }
    private Node pobierzPierwszaGalaz(Node galaz, String nazwa) {
        NodeList dzieci = galaz.getChildNodes();
        for (int i=0;i<dzieci.getLength();i++) {
            String nazwaDziecka = dzieci.item(i).getNodeName();
            if (nazwaDziecka != null && nazwaDziecka.equals(nazwa))
                return dzieci.item(i);
        }
        return null;
    }
}
