/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.comet;

import com.sun.enterprise.web.connector.grizzly.AsyncHandler;
import com.sun.enterprise.web.connector.grizzly.Pipeline;
import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.async.AsyncProcessorTask;
import com.sun.enterprise.web.connector.grizzly.comet.CometContext;
import com.sun.enterprise.web.connector.grizzly.comet.CometSelector;
import com.sun.enterprise.web.connector.grizzly.comet.CometTask;
import com.sun.enterprise.web.connector.grizzly.comet.DefaultNotificationHandler;
import com.sun.enterprise.web.connector.grizzly.comet.NotificationHandler;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CometEngine {
    public static final int BEFORE_REQUEST_PROCESSING = 0;
    public static final int AFTER_SERVLET_PROCESSING = 1;
    public static final int AFTER_RESPONSE_PROCESSING = 2;
    private static final Logger logger = SelectorThread.logger();
    private Pipeline pipeline;
    private static CometEngine cometEngine;
    private ConcurrentHashMap<String, CometContext> activeContexts = new ConcurrentHashMap();
    private ConcurrentLinkedQueue<CometTask> cometTasks = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<CometContext> cometContexts = new ConcurrentLinkedQueue();
    private CometSelector cometSelector = new CometSelector(this);
    private static String notificationHandlerClassName;
    private ConcurrentHashMap<Long, SelectionKey> threadsId;
    private ConcurrentHashMap<Long, CometContext> updatedCometContexts;

    private CometEngine() {
        this.cometSelector.start();
        this.threadsId = new ConcurrentHashMap();
        this.updatedCometContexts = new ConcurrentHashMap();
    }

    public static final synchronized CometEngine getEngine() {
        if (cometEngine == null) {
            cometEngine = new CometEngine();
        }
        return cometEngine;
    }

    public CometContext unregister(String contextPath) {
        CometContext cometContext = this.activeContexts.get(contextPath);
        try {
            cometContext.notify(cometContext, 3);
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "unregister", ex);
        }
        this.finalizeContext(cometContext);
        return this.activeContexts.remove(contextPath);
    }

    public CometContext register(String contextPath) {
        return this.register(contextPath, 1);
    }

    public CometContext register(String contextPath, int type) {
        CometContext cometContext = this.activeContexts.get(contextPath);
        if (cometContext == null) {
            cometContext = this.cometContexts.poll();
            if (cometContext == null) {
                cometContext = new CometContext(contextPath, type);
                cometContext.setCometSelector(this.cometSelector);
                NotificationHandler notificationHandler = CometEngine.loadNotificationHandlerInstance(notificationHandlerClassName);
                cometContext.setNotificationHandler(notificationHandler);
                if (notificationHandler != null && notificationHandler instanceof DefaultNotificationHandler) {
                    ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
                }
            }
            this.activeContexts.put(contextPath, cometContext);
        }
        return cometContext;
    }

    protected boolean handle(AsyncProcessorTask apt) throws IOException {
        NotificationHandler notificationHandler;
        if (this.pipeline == null) {
            this.pipeline = apt.getPipeline();
        }
        String contextPath = apt.getProcessorTask().getRequestURI();
        CometContext cometContext = null;
        if (contextPath != null && (cometContext = this.activeContexts.get(contextPath)) != null && (notificationHandler = cometContext.getNotificationHandler()) != null && notificationHandler instanceof DefaultNotificationHandler) {
            ((DefaultNotificationHandler)notificationHandler).setPipeline(this.pipeline);
        }
        boolean activateContinuation = true;
        SelectionKey key = apt.getProcessorTask().getSelectionKey();
        this.threadsId.put(Thread.currentThread().getId(), key);
        int continuationType = cometContext == null ? 1 : cometContext.continuationType;
        this.executeServlet(continuationType, apt);
        cometContext = this.updatedCometContexts.remove(Thread.currentThread().getId());
        if (cometContext == null) {
            activateContinuation = false;
        }
        boolean parkRequest = true;
        if (activateContinuation) {
            CometContext.addInProgressSelectionKey(key);
            key.attach(null);
            boolean isBlocking = cometContext.isBlockingNotification();
            cometContext.setBlockingNotification(true);
            cometContext.initialize(key);
            cometContext.setBlockingNotification(isBlocking);
            if (cometContext.getCometHandler(key) != null) {
                cometContext.addAsyncProcessorTask(apt);
                if (cometContext.getExpirationDelay() != -1L) {
                    CometTask cometTask = this.getCometTask(cometContext, key, apt.getPipeline());
                    cometTask.setSelectorThread(apt.getProcessorTask().getSelectorThread());
                    cometTask.setExpirationDelay(cometContext.getExpirationDelay());
                    cometTask.setSelectorThread(apt.getSelectorThread());
                    this.cometSelector.registerKey(key, cometTask);
                }
            }
            CometContext.removeInProgressSelectionKey(key);
        } else {
            parkRequest = false;
        }
        return parkRequest;
    }

    protected SelectionKey activateContinuation(Long threadId, CometContext cometContext, boolean continueExecution) {
        if (!continueExecution) {
            this.updatedCometContexts.put(threadId, cometContext);
        }
        return this.threadsId.remove(threadId);
    }

    protected CometTask getCometTask(CometContext cometContext, SelectionKey key, Pipeline ctxPipeline) {
        CometTask cometTask = this.cometTasks.poll();
        if (cometTask == null) {
            cometTask = new CometTask();
        }
        cometTask.setCometContext(cometContext);
        cometTask.setSelectionKey(key);
        cometTask.setCometSelector(this.cometSelector);
        cometTask.setPipeline(ctxPipeline);
        return cometTask;
    }

    private void finalizeContext(CometContext cometContext) {
        for (String contextPath : this.activeContexts.keySet()) {
            if (!this.activeContexts.get(contextPath).equals(cometContext)) continue;
            this.activeContexts.remove(contextPath);
            break;
        }
        ConcurrentLinkedQueue<AsyncProcessorTask> asyncTasks = cometContext.getAsyncProcessorTask();
        for (AsyncProcessorTask apt : asyncTasks) {
            this.flushResponse(apt);
        }
        cometContext.recycle();
        this.cometContexts.offer(cometContext);
    }

    public CometContext getCometContext(String contextPath) {
        return this.activeContexts.get(contextPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void interrupt(SelectionKey key) {
        CometTask cometTask = (CometTask)key.attachment();
        key.attach(null);
        if (cometTask == null) {
            throw new IllegalStateException("cometTask cannot be null");
        }
        SelectionKey akey = cometTask.getSelectionKey();
        try {
            if (akey == null || !akey.isValid()) {
                return;
            }
            CometContext cometContext = cometTask.getCometContext();
            Iterator<AsyncProcessorTask> iterator = cometContext.getAsyncProcessorTask().iterator();
            AsyncHandler ah = null;
            while (iterator.hasNext()) {
                AsyncProcessorTask apt = iterator.next();
                ah = apt.getAsyncExecutor().getAsyncHandler();
                if (apt.getProcessorTask().getSelectionKey() != akey) continue;
                iterator.remove();
                ah.removeFromInterruptedQueue(apt);
                if (akey != null) {
                    akey.attach(null);
                }
                if (apt.getStage() != 2) {
                } else {
                    this.flushResponse(apt);
                }
                break;
            }
        }
        finally {
            this.returnTask(cometTask);
        }
    }

    protected void returnTask(CometTask cometTask) {
        cometTask.recycle();
        this.cometTasks.offer(cometTask);
    }

    protected void resume(SelectionKey key, CometContext cometContext) {
        Iterator<AsyncProcessorTask> iterator = cometContext.getAsyncProcessorTask().iterator();
        while (iterator.hasNext()) {
            AsyncProcessorTask apt = iterator.next();
            if (apt.getProcessorTask().getSelectionKey() != key) continue;
            iterator.remove();
            if (apt.getStage() != 2) break;
            apt.getAsyncExecutor().getAsyncHandler().removeFromInterruptedQueue(apt);
            this.flushResponse(apt);
            break;
        }
    }

    private void flushResponse(AsyncProcessorTask apt) {
        apt.setStage(2);
        try {
            apt.doTask();
        }
        catch (IllegalStateException ex) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "flushResponse failed", ex);
            }
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "flushResponse failed", ex);
        }
    }

    private void executeServlet(int continuationType, AsyncProcessorTask apt) {
        switch (continuationType) {
            case 0: {
                apt.setStage(0);
                break;
            }
            case 1: {
                apt.getProcessorTask().invokeAdapter();
                return;
            }
            case 2: {
                apt.setStage(2);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid state");
            }
        }
        try {
            apt.doTask();
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "executeServlet", ex);
        }
    }

    public static String getNotificationHandlerClassName() {
        return notificationHandlerClassName;
    }

    public static void setNotificationHandlerClassName(String aNotificationHandlerClassName) {
        notificationHandlerClassName = aNotificationHandlerClassName;
    }

    private static NotificationHandler loadNotificationHandlerInstance(String className) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            return (NotificationHandler)clazz.newInstance();
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "Invalid NotificationHandler: ", t);
            return new DefaultNotificationHandler();
        }
    }

    public static final Logger logger() {
        return logger;
    }

    static {
        notificationHandlerClassName = DefaultNotificationHandler.class.getName();
    }
}

