/*
 * Decompiled with CFR 0.152.
 */
package pl.helion.j2mepp.notatki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Notatka {
    private String nazwa;
    private String opis;
    private long data;

    public Notatka(String p_nazwa, String p_opis, long p_data) {
        this.nazwa = p_nazwa;
        this.opis = p_opis;
        this.data = p_data;
    }

    public long getData() {
        return this.data;
    }

    public String getNazwa() {
        return this.nazwa;
    }

    public String getOpis() {
        return this.opis;
    }

    public Notatka(byte[] dane) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(dane));
            this.nazwa = in.readUTF();
            this.opis = in.readUTF();
            this.data = in.readLong();
            in.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        byte[] bufor = new byte[]{};
        try {
            out.writeUTF(this.nazwa);
            out.writeUTF(this.opis);
            out.writeLong(this.data);
            bufor = baos.toByteArray();
            baos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return bufor;
    }

    public static long PelnaDatawData(int rok, int mies, int dzien, int godz, int min, int sek) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        cal.set(1, rok);
        cal.set(2, mies);
        cal.set(5, dzien);
        cal.set(11, godz);
        cal.set(12, min);
        cal.set(13, sek);
        return cal.getTime().getTime();
    }

    private String zero(int wartosc) {
        if (wartosc < 10) {
            return "0" + wartosc;
        }
        return "" + wartosc;
    }

    public String getPelnaData() {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        Date obiekt_data = new Date(this.data);
        cal.setTime(obiekt_data);
        String wynik = cal.get(1) + "-";
        wynik = wynik + this.zero(cal.get(2) + 1) + "-";
        wynik = wynik + this.zero(cal.get(5)) + " ";
        wynik = wynik + this.zero(cal.get(11) + 2) + ":";
        wynik = wynik + this.zero(cal.get(12)) + ":";
        wynik = wynik + this.zero(cal.get(13));
        return wynik;
    }
}

