/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.modeler.rmi;

import com.sun.xml.rpc.processor.modeler.rmi.RmiConstants;
import java.util.HashMap;
import java.util.Map;

public class RmiUtils
implements RmiConstants {
    private static final Map typeClassMap = new HashMap();

    public static String getTypeSig(String typeName) {
        String sig = "";
        int idx = typeName.lastIndexOf("[]");
        if (idx > 0) {
            return "[" + RmiUtils.getTypeSig(typeName.substring(0, idx));
        }
        if (typeName.equals("boolean")) {
            return "Z";
        }
        if (typeName.equals("byte")) {
            return "B";
        }
        if (typeName.equals("char")) {
            return "C";
        }
        if (typeName.equals("short")) {
            return "S";
        }
        if (typeName.equals("int")) {
            return "I";
        }
        if (typeName.equals("long")) {
            return "J";
        }
        if (typeName.equals("float")) {
            return "F";
        }
        if (typeName.equals("double")) {
            return "D";
        }
        if (typeName.equals("void")) {
            return "V";
        }
        return "L" + typeName.replace('.', '/') + ";";
    }

    public static String getRealName(String name, ClassLoader loader) throws ClassNotFoundException {
        String tmpName = name;
        if (name.lastIndexOf("[]") > 0) {
            tmpName = RmiUtils.getTypeSig(name).replace('/', '.');
        }
        tmpName = RmiUtils.getLoadableClassName(tmpName, loader);
        return tmpName;
    }

    public static Class getClassForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> tmpClass = (Class<?>)typeClassMap.get(name);
        if (tmpClass != null) {
            return tmpClass;
        }
        String tmpName = name;
        if (name.lastIndexOf("[]") > 0) {
            tmpName = RmiUtils.getTypeSig(name).replace('/', '.');
        }
        tmpName = RmiUtils.getLoadableClassName(tmpName, classLoader);
        tmpClass = Class.forName(tmpName, true, classLoader);
        return tmpClass;
    }

    public static String getLoadableClassName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        try {
            Class<?> seiClass = Class.forName(className, true, classLoader);
        }
        catch (ClassNotFoundException e) {
            int idx = className.lastIndexOf(46);
            if (idx > -1) {
                String tmp = className.substring(0, idx) + "$";
                tmp = tmp + className.substring(idx + 1);
                return RmiUtils.getLoadableClassName(tmp, classLoader);
            }
            throw e;
        }
        return className;
    }

    static {
        typeClassMap.put("boolean", Boolean.TYPE);
        typeClassMap.put("byte", Byte.TYPE);
        typeClassMap.put("char", Character.TYPE);
        typeClassMap.put("double", Double.TYPE);
        typeClassMap.put("float", Float.TYPE);
        typeClassMap.put("int", Integer.TYPE);
        typeClassMap.put("long", Long.TYPE);
        typeClassMap.put("short", Short.TYPE);
        typeClassMap.put("void", Void.TYPE);
    }
}

