/*
 * Decompiled with CFR 0.152.
 */
package com.rychlickikicior.kitijdb;

import com.rychlickikicior.kitijdb.QueryType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Query {
    private String name;
    private QueryType type;
    private String content;
    private Map<String, Object> params = new LinkedHashMap<String, Object>();
    private List values;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public QueryType getType() {
        return this.type;
    }

    public void setType(QueryType type) {
        this.type = type;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.params.clear();
        Pattern p = Pattern.compile(":[a-zA-Z0-9]+");
        Matcher m = p.matcher(content);
        while (m.find()) {
            this.params.put(m.group().substring(1), "");
        }
        this.content = content.replaceAll(":", ":__");
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public Collection<String> getParameterNames() {
        return this.params.keySet();
    }

    public void setParameter(String key, Object value) {
        this.params.put(key, value);
    }

    private int getNthOccurence(String hayStack, int nth, String needle) {
        int i = 0;
        int index = 0;
        while (i++ < nth) {
            index = hayStack.indexOf(needle, index + 1);
        }
        return index;
    }

    public String prepare() {
        String query = new String(this.content);
        String oldQuery = new String(this.content);
        TreeMap<Integer, String> indexKey = new TreeMap<Integer, String>();
        this.values = new ArrayList();
        boolean changed = true;
        int iteration = 1;
        while (changed) {
            changed = false;
            for (String key : this.params.keySet()) {
                String newKey = ":__" + key;
                int index = query.indexOf(newKey);
                if (index <= -1) continue;
                changed = true;
                query = query.replaceFirst(newKey, "?");
                indexKey.put(this.getNthOccurence(oldQuery, iteration, newKey), key);
            }
            ++iteration;
        }
        for (Integer i : indexKey.keySet()) {
            this.values.add(this.params.get(indexKey.get(i)));
        }
        for (String key : this.params.keySet()) {
            this.params.put(key, "");
        }
        return query;
    }

    public void fillValues(PreparedStatement p) {
        for (int i = 0; i < this.values.size(); ++i) {
            try {
                p.setObject(i + 1, this.values.get(i));
                continue;
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        this.values = null;
    }
}

