/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly.ssl;

import com.sun.enterprise.web.connector.grizzly.SelectorThread;
import com.sun.enterprise.web.connector.grizzly.StreamAlgorithm;
import com.sun.enterprise.web.connector.grizzly.TaskContext;
import com.sun.enterprise.web.connector.grizzly.TaskEvent;
import com.sun.enterprise.web.connector.grizzly.TaskListener;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLAsyncOutputBuffer;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLAsyncProcessorTask;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLAsyncStream;
import com.sun.enterprise.web.connector.grizzly.ssl.SSLReadTask;
import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.logging.Level;

public class SSLAsyncReadTask
extends SSLReadTask {
    public void allocateBuffers() {
        ByteBuffer newBB;
        int expectedSize = this.sslEngine.getSession().getPacketBufferSize();
        if (this.inputBBSize < expectedSize) {
            this.inputBBSize = expectedSize;
        }
        if (this.inputBB != null && this.inputBB.capacity() < this.inputBBSize) {
            newBB = ByteBuffer.allocate(this.inputBBSize);
            this.inputBB.flip();
            newBB.put(this.inputBB);
            this.inputBB = newBB;
        } else if (this.inputBB == null) {
            this.inputBB = ByteBuffer.allocate(this.inputBBSize);
        }
        this.outputBB = ByteBuffer.allocate(this.inputBBSize);
        if (this.byteBuffer == null) {
            this.byteBuffer = ByteBuffer.allocate(this.inputBBSize * 2);
        }
        if ((expectedSize = this.sslEngine.getSession().getApplicationBufferSize()) > this.byteBuffer.capacity()) {
            newBB = ByteBuffer.allocate(expectedSize);
            this.byteBuffer.flip();
            newBB.put(this.byteBuffer);
            this.byteBuffer = newBB;
        }
        this.outputBB.position(0);
        this.outputBB.limit(0);
    }

    public void initialize(StreamAlgorithm algorithm, boolean useDirectByteBuffer, boolean useByteBufferView) {
        this.type = 1;
        this.algorithm = algorithm;
        this.inputStream = new SSLAsyncStream();
        this.useDirectByteBuffer = useDirectByteBuffer;
        this.useByteBufferView = useByteBufferView;
    }

    protected void manageKeepAlive(boolean keepAlive, int count, Exception exception) {
        if (count == -1 || exception != null) {
            if (exception != null) {
                this.detachProcessor();
                if (SelectorThread.logger().isLoggable(Level.FINE)) {
                    SelectorThread.logger().log(Level.FINE, "SocketChannel Read Exception:", exception);
                }
            }
            this.terminate(false);
        }
    }

    protected boolean process() throws IOException {
        boolean keepAlive = false;
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        Socket socket = socketChannel.socket();
        this.algorithm.setSocketChannel(socketChannel);
        this.inputStream.setSelectionKey(this.key);
        ((SSLAsyncStream)this.inputStream).setSslEngine(this.sslEngine);
        ((SSLAsyncStream)this.inputStream).setInputBB(this.inputBB);
        if (this.processorTask == null) {
            this.attachProcessor(this.selectorThread.getProcessorTask());
        }
        if (this.algorithm.parse(this.byteBuffer)) {
            return this.executeProcessorTask();
        }
        return true;
    }

    public boolean executeProcessorTask() throws IOException {
        if (SelectorThread.logger().isLoggable(Level.FINEST)) {
            SelectorThread.logger().log(Level.FINEST, "executeProcessorTask");
        }
        if (this.algorithm.getHandler() != null && this.algorithm.getHandler().handle(null, 2) == 1) {
            return true;
        }
        if (this.taskEvent == null) {
            this.taskContext = new TaskContext();
            this.taskEvent = new TaskEvent<TaskContext>(this.taskContext);
        }
        this.taskEvent.setStatus(0);
        this.taskContext.setInputStream(this.inputStream);
        this.taskEvent.attach(this.taskContext);
        this.fireTaskEvent(this.taskEvent);
        return false;
    }

    public void recycle() {
        this.byteBuffer = this.algorithm.postParse(this.byteBuffer);
        this.byteBuffer.clear();
        this.inputStream.recycle();
        this.algorithm.recycle();
        this.key = null;
        this.inputStream.setSelectionKey(null);
        this.handshake = true;
        this.inputBB.clear();
        this.outputBB.clear();
        this.outputBB.position(0);
        this.outputBB.limit(0);
        this.sslEngine = null;
        this.detachProcessor();
    }

    public void terminate(boolean keepAlive) {
        if (this.processorTask != null && this.processorTask.isKeepAlive()) {
            this.detachProcessor();
            this.registerKey();
            this.returnTask();
        } else {
            super.terminate(keepAlive);
        }
    }

    public void configureProcessorTask() {
        super.configureProcessorTask();
        if (!this.getTaskListeners().contains(this.processorTask)) {
            this.processorTask.addTaskListener(this);
            this.addTaskListener((TaskListener)((Object)this.processorTask));
        }
        this.processorTask.initialize();
        SSLAsyncOutputBuffer outputBuffer = ((SSLAsyncProcessorTask)this.processorTask).getSSLAsyncOutputBuffer();
        outputBuffer.setSSLEngine(this.sslEngine);
        outputBuffer.setOutputBB(this.outputBB);
    }
}

