/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.impl.c14n;

import com.sun.xml.wss.impl.c14n.Attribute;
import com.sun.xml.wss.impl.c14n.AttributeNS;
import com.sun.xml.wss.impl.misc.UnsyncByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import org.xml.sax.Attributes;

public abstract class BaseCanonicalizer {
    static final byte[] _END_PI = new byte[]{63, 62};
    static final byte[] _BEGIN_PI = new byte[]{60, 63};
    static final byte[] _END_COMM = new byte[]{45, 45, 62};
    static final byte[] _BEGIN_COMM = new byte[]{60, 33, 45, 45};
    static final byte[] __XA_ = new byte[]{38, 35, 120, 65, 59};
    static final byte[] __X9_ = new byte[]{38, 35, 120, 57, 59};
    static final byte[] _QUOT_ = new byte[]{38, 113, 117, 111, 116, 59};
    static final byte[] __XD_ = new byte[]{38, 35, 120, 68, 59};
    static final byte[] _GT_ = new byte[]{38, 103, 116, 59};
    static final byte[] _LT_ = new byte[]{38, 108, 116, 59};
    static final byte[] _END_TAG = new byte[]{60, 47};
    static final byte[] _AMP_ = new byte[]{38, 97, 109, 112, 59};
    static final String XML = "xml";
    static final String XMLNS = "xmlns";
    static final byte[] equalsStr = new byte[]{61, 34};
    static final int NODE_BEFORE_DOCUMENT_ELEMENT = -1;
    static final int NODE_NOT_BEFORE_OR_AFTER_DOCUMENT_ELEMENT = 0;
    static final int NODE_AFTER_DOCUMENT_ELEMENT = 1;
    protected ArrayList _attrs = new ArrayList();
    protected ArrayList _nsAttrs = new ArrayList();
    int _attrPos = 0;
    int _attrNSPos = 0;
    protected List _attrResult = null;
    protected List _nsResult = new ArrayList();
    String _defURI = null;
    OutputStream _stream = null;
    boolean[] _ncContextState = new boolean[20];
    StringBuffer _attrName = new StringBuffer();
    int _depth = 0;
    protected static final int initalCacheSize = 4;
    boolean _parentNamespacesAdded = false;
    String _elementPrefix = "";
    private static boolean debug = false;

    public void reset() {
        this._nsResult.clear();
        this._attrResult.clear();
        this._attrPos = 0;
        this._depth = 0;
        this._parentNamespacesAdded = false;
    }

    public void setStream(OutputStream os) {
        this._stream = os;
    }

    public OutputStream getOutputStream() {
        return this._stream;
    }

    protected final void resize() {
        if (this._depth >= this._ncContextState.length) {
            boolean[] tmp = new boolean[this._ncContextState.length + 20];
            System.arraycopy(this._ncContextState, 0, tmp, 0, this._ncContextState.length);
            this._ncContextState = tmp;
        }
    }

    public void addParentNamespaces(List nsDecls) {
        if (!this._parentNamespacesAdded) {
            this._nsResult.addAll(nsDecls);
            this._parentNamespacesAdded = true;
        }
    }

    protected AttributeNS getAttributeNS() {
        if (this._attrNSPos < this._nsAttrs.size()) {
            return (AttributeNS)this._nsAttrs.get(this._attrNSPos++);
        }
        for (int i = 0; i < 4; ++i) {
            this._nsAttrs.add(new AttributeNS());
        }
        return (AttributeNS)this._nsAttrs.get(this._attrNSPos++);
    }

    protected void writeAttributes(Attributes attributes, Iterator itr) throws IOException {
        while (itr.hasNext()) {
            Attribute attr = (Attribute)itr.next();
            int pos = attr.getPosition();
            BaseCanonicalizer.outputAttrToWriter(attributes.getQName(pos), attributes.getValue(pos), this._stream);
        }
        this._attrResult.iterator();
    }

    protected void writeAttributesNS(Iterator itr) throws IOException {
        while (itr.hasNext()) {
            AttributeNS attr = (AttributeNS)itr.next();
            String prefix = attr.getPrefix();
            if (prefix.length() != 0) {
                this._attrName.setLength(0);
                this._attrName.append("xmlns:");
                this._attrName.append(prefix);
                prefix = this._attrName.toString();
            } else {
                prefix = XMLNS;
            }
            BaseCanonicalizer.outputAttrToWriter(prefix, attr.getUri(), this._stream);
        }
    }

    void outputTextToWriter(char[] text, int start, int length, OutputStream writer) throws IOException {
        byte[] toWrite = null;
        block7: for (int i = start; i < start + length; ++i) {
            char c = text[i];
            switch (c) {
                case '&': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _LT_;
                    break;
                }
                case '>': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _GT_;
                    break;
                }
                case '\r': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = __XD_;
                    break;
                }
                case '\n': {
                    toWrite = null;
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    break;
                }
                default: {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                        toWrite = null;
                    }
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    continue block7;
                }
            }
            if (toWrite == null || Arrays.equals(toWrite, __XD_)) continue;
            writer.write(toWrite);
        }
    }

    static final void outputAttrToWriter(String name, String value, OutputStream writer) throws IOException {
        writer.write(32);
        BaseCanonicalizer.writeStringToUtf8(name, writer);
        writer.write(equalsStr);
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '\"': {
                    toWrite = _QUOT_;
                    break;
                }
                case '\t': {
                    toWrite = __X9_;
                    break;
                }
                case '\n': {
                    toWrite = __XA_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    continue block8;
                }
            }
            writer.write(toWrite);
        }
        writer.write(34);
    }

    static final void outputAttrToWriter(String prefix, String localName, String value, OutputStream writer) throws IOException {
        writer.write(32);
        if (localName.length() != 0) {
            BaseCanonicalizer.writeStringToUtf8(prefix, writer);
            BaseCanonicalizer.writeStringToUtf8(":", writer);
            BaseCanonicalizer.writeStringToUtf8(localName, writer);
        } else {
            BaseCanonicalizer.writeStringToUtf8(prefix, writer);
        }
        writer.write(equalsStr);
        int length = value.length();
        block8: for (int i = 0; i < length; ++i) {
            byte[] toWrite;
            char c = value.charAt(i);
            switch (c) {
                case '&': {
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    toWrite = _LT_;
                    break;
                }
                case '\"': {
                    toWrite = _QUOT_;
                    break;
                }
                case '\t': {
                    toWrite = __X9_;
                    break;
                }
                case '\n': {
                    toWrite = __XA_;
                    break;
                }
                case '\r': {
                    toWrite = __XD_;
                    break;
                }
                default: {
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    continue block8;
                }
            }
            writer.write(toWrite);
        }
        writer.write(34);
    }

    static final void writeCharToUtf8(char c, OutputStream out) throws IOException {
        int bias;
        int write;
        char ch;
        if (c <= '\u007f') {
            out.write(c);
            return;
        }
        if (c > '\u07ff') {
            ch = (char)(c >>> 12);
            write = 224;
            if (ch > '\u0000') {
                write |= ch & 0xF;
            }
            out.write(write);
            write = 128;
            bias = 63;
        } else {
            write = 192;
            bias = 31;
        }
        ch = (char)(c >>> 6);
        if (ch > '\u0000') {
            write |= ch & bias;
        }
        out.write(write);
        out.write(0x80 | c & 0x3F);
    }

    static final void writeStringToUtf8(String str, OutputStream out) throws IOException {
        int length = str.length();
        int i = 0;
        while (i < length) {
            int bias;
            int write;
            char ch;
            char c;
            if ((c = str.charAt(i++)) <= '\u007f') {
                out.write(c);
                continue;
            }
            if (c > '\u07ff') {
                ch = (char)(c >>> 12);
                write = 224;
                if (ch > '\u0000') {
                    write |= ch & 0xF;
                }
                out.write(write);
                write = 128;
                bias = 63;
            } else {
                write = 192;
                bias = 31;
            }
            ch = (char)(c >>> 6);
            if (ch > '\u0000') {
                write |= ch & bias;
            }
            out.write(write);
            out.write(0x80 | c & 0x3F);
        }
    }

    static final void outputPItoWriter(String target, String data, OutputStream writer) throws IOException {
        char c;
        int i;
        writer.write(10);
        writer.write(_BEGIN_PI);
        int length = target.length();
        for (i = 0; i < length; ++i) {
            c = target.charAt(i);
            if (c == '\r') {
                writer.write(__XD_);
                continue;
            }
            BaseCanonicalizer.writeCharToUtf8(c, writer);
        }
        length = data.length();
        if (length > 0) {
            writer.write(32);
            for (i = 0; i < length; ++i) {
                c = data.charAt(i);
                if (c == '\r') {
                    writer.write(__XD_);
                    continue;
                }
                BaseCanonicalizer.writeCharToUtf8(c, writer);
            }
        }
        writer.write(_END_PI);
    }

    static final void outputCommentToWriter(String data, OutputStream writer) throws IOException {
        writer.write(10);
        writer.write(_BEGIN_COMM);
        int length = data.length();
        for (int i = 0; i < length; ++i) {
            char c = data.charAt(i);
            if (c == '\r') {
                writer.write(__XD_);
                continue;
            }
            BaseCanonicalizer.writeCharToUtf8(c, writer);
        }
        writer.write(_END_COMM);
    }

    void outputTextToWriter(String text, OutputStream writer) throws IOException {
        byte[] toWrite = null;
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _AMP_;
                    break;
                }
                case '<': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _LT_;
                    break;
                }
                case '>': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = _GT_;
                    break;
                }
                case '\r': {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                    }
                    toWrite = __XD_;
                    break;
                }
                case '\n': {
                    toWrite = null;
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    break;
                }
                default: {
                    if (Arrays.equals(toWrite, __XD_)) {
                        writer.write(toWrite);
                        toWrite = null;
                    }
                    BaseCanonicalizer.writeCharToUtf8(c, writer);
                    continue block7;
                }
            }
            if (toWrite == null || Arrays.equals(toWrite, __XD_)) continue;
            writer.write(toWrite);
        }
    }

    public static boolean namespaceIsRelative(String namespaceValue) {
        return !BaseCanonicalizer.namespaceIsAbsolute(namespaceValue);
    }

    public static boolean namespaceIsAbsolute(String namespaceValue) {
        if (namespaceValue.length() == 0) {
            return true;
        }
        return namespaceValue.indexOf(58) > 0;
    }

    public static void sort(List list) {
        int size = list.size();
        for (int iterator = 0; iterator < size; ++iterator) {
            for (int iterator1 = iterator + 1; iterator1 < size; ++iterator1) {
                if (((Comparable)list.get(iterator1)).compareTo(list.get(iterator)) < 0) continue;
                BaseCanonicalizer.swap(list, iterator1, iterator);
            }
        }
    }

    private static void swap(List x, int a, int b) {
        Object t = x.get(a);
        x.set(a, x.get(b));
        x.set(b, t);
    }

    static class ElementName {
        private UnsyncByteArrayOutputStream utf8Data = new UnsyncByteArrayOutputStream(20);

        ElementName() {
        }

        public UnsyncByteArrayOutputStream getUtf8Data() {
            return this.utf8Data;
        }

        public void setUtf8Data(UnsyncByteArrayOutputStream utf8Data) {
            this.utf8Data = utf8Data;
        }
    }

    static class UsedNSList {
        ArrayList usedPrefixList = new ArrayList();
        ArrayList popPrefixList = new ArrayList();

        UsedNSList() {
        }

        public ArrayList getPopList() {
            return this.popPrefixList;
        }

        public ArrayList getUsedPrefixList() {
            return this.usedPrefixList;
        }

        public void clear() {
            this.usedPrefixList.clear();
            this.popPrefixList.clear();
        }
    }

    public static class NamespaceContextImpl
    implements NamespaceContext {
        AttributeNS nsDecl = new AttributeNS();
        HashMap prefixMappings = new HashMap();
        ArrayList clearDepth = new ArrayList(10);
        int nsDepth;
        int resizeBy = 10;

        public NamespaceContextImpl() {
            for (int i = 0; i < 10; ++i) {
                this.clearDepth.add(null);
            }
        }

        public AttributeNS getNamespaceDeclaration(String prefix) {
            Stack stack = (Stack)this.prefixMappings.get(prefix);
            if (stack == null || stack.empty()) {
                return null;
            }
            AttributeNS attrNS = (AttributeNS)stack.peek();
            if (attrNS.isWritten()) {
                if (debug) {
                    System.out.println("depth " + this.nsDepth + " did not return prefix " + prefix);
                }
                return null;
            }
            UsedNSList uList = null;
            uList = (UsedNSList)this.clearDepth.get(this.nsDepth);
            if (uList == null) {
                uList = new UsedNSList();
                this.clearDepth.set(this.nsDepth, uList);
            }
            if (debug) {
                System.out.println("depth " + this.nsDepth + " return prefix " + prefix);
            }
            uList.getUsedPrefixList().add(prefix);
            return attrNS;
        }

        public void declareNamespace(String prefix, String uri) {
            Stack<Object> nsDecls = (Stack<Object>)this.prefixMappings.get(prefix);
            this.nsDecl.setPrefix(prefix);
            this.nsDecl.setUri(uri);
            if (nsDecls == null) {
                nsDecls = new Stack<Object>();
                try {
                    nsDecls.add(this.nsDecl.clone());
                    this.prefixMappings.put(prefix, nsDecls);
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            } else if (!nsDecls.contains(this.nsDecl)) {
                try {
                    nsDecls.add(this.nsDecl.clone());
                }
                catch (CloneNotSupportedException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                return;
            }
            UsedNSList uList = null;
            uList = (UsedNSList)this.clearDepth.get(this.nsDepth);
            if (uList == null) {
                uList = new UsedNSList();
                this.clearDepth.set(this.nsDepth, uList);
            }
            ArrayList prefixList = uList.getPopList();
            prefixList.add(prefix);
        }

        public void push() {
            ++this.nsDepth;
            if (debug) {
                System.out.println("--------------------Push depth----------------" + this.nsDepth);
            }
            if (this.nsDepth >= this.clearDepth.size()) {
                int len;
                this.clearDepth.ensureCapacity(this.clearDepth.size() + this.resizeBy);
                for (int i = len = this.clearDepth.size(); i < len + this.resizeBy; ++i) {
                    this.clearDepth.add(null);
                }
            }
        }

        public void pop() {
            if (this.nsDepth <= 0) {
                return;
            }
            UsedNSList ul = (UsedNSList)this.clearDepth.get(this.nsDepth);
            if (debug) {
                System.out.println("---------------------pop depth----------------------" + this.nsDepth);
            }
            --this.nsDepth;
            if (ul == null) {
                return;
            }
            ArrayList pList = ul.getPopList();
            for (int i = 0; i < pList.size(); ++i) {
                String prefix = (String)pList.get(i);
                Stack stack = (Stack)this.prefixMappings.get(prefix);
                if (debug) {
                    System.out.println("clear prefix" + prefix);
                }
                if (stack.isEmpty()) continue;
                stack.pop();
            }
            ArrayList rList = ul.getUsedPrefixList();
            for (int i = 0; i < rList.size(); ++i) {
                String prefix = (String)rList.get(i);
                if (pList.contains(prefix)) continue;
                Stack stack = (Stack)this.prefixMappings.get(prefix);
                if (debug) {
                    System.out.println("reset written prefix" + prefix);
                }
                if (stack.isEmpty()) continue;
                AttributeNS attrNS = (AttributeNS)stack.peek();
                attrNS.setWritten(false);
            }
            pList.clear();
            rList.clear();
        }

        public void reset() {
            this.nsDepth = 0;
            for (int i = 0; i < this.clearDepth.size(); ++i) {
                UsedNSList ul = (UsedNSList)this.clearDepth.get(i);
                if (ul == null) continue;
                ul.clear();
            }
        }

        public String getNamespaceURI(String prefix) {
            Stack stack = (Stack)this.prefixMappings.get(prefix);
            if (stack == null || stack.empty()) {
                return "";
            }
            AttributeNS attrNS = (AttributeNS)stack.peek();
            return attrNS.getUri();
        }

        public String getPrefix(String namespaceURI) {
            Set keys = this.prefixMappings.keySet();
            for (String key : keys) {
                AttributeNS attrNS;
                Stack stack = (Stack)this.prefixMappings.get(key);
                if (stack == null || stack.empty() || !namespaceURI.equals((attrNS = (AttributeNS)stack.peek()).getUri())) continue;
                return key;
            }
            return null;
        }

        public Iterator getPrefixes(String namespaceURI) {
            Set keys = this.prefixMappings.keySet();
            ArrayList<String> list = new ArrayList<String>();
            for (String key : keys) {
                AttributeNS attrNS;
                Stack stack = (Stack)this.prefixMappings.get(key);
                if (stack == null || stack.empty() || !namespaceURI.equals((attrNS = (AttributeNS)stack.peek()).getUri())) continue;
                list.add(key);
            }
            return list.iterator();
        }
    }
}

