/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.tx.common;

import com.sun.xml.ws.api.tx.ATTransaction;
import com.sun.xml.ws.api.tx.Participant;
import com.sun.xml.ws.tx.at.ATCoordinator;
import com.sun.xml.ws.tx.at.ATParticipant;
import com.sun.xml.ws.tx.coordinator.CoordinationContextInterface;
import com.sun.xml.ws.tx.coordinator.CoordinationManager;
import com.sun.xml.ws.tx.coordinator.Coordinator;
import java.util.HashMap;
import java.util.Map;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class ATTransactionImpl
implements ATTransaction {
    private final Transaction txn;
    private final CoordinationContextInterface coordCtx;
    private final ATCoordinator COORDINATOR;
    private static Map<String, ATTransactionImpl> coordIdATtxnMap = new HashMap<String, ATTransactionImpl>();

    public static ATTransactionImpl get(String coordinationId) {
        return coordIdATtxnMap.get(coordinationId);
    }

    public void forget() {
        coordIdATtxnMap.remove(this.coordCtx.getIdentifier());
    }

    public ATTransactionImpl(Transaction jtaTxn, CoordinationContextInterface coordCtx) {
        this.txn = jtaTxn;
        this.coordCtx = coordCtx;
        this.COORDINATOR = (ATCoordinator)CoordinationManager.getInstance().getCoordinator(coordCtx.getIdentifier());
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        this.txn.commit();
    }

    public boolean delistResource(XAResource xAResource, int state) throws IllegalStateException, SystemException {
        return this.txn.delistResource(xAResource, state);
    }

    public boolean enlistResource(XAResource xaResource) throws RollbackException, IllegalStateException, SystemException {
        return this.txn.enlistResource(xaResource);
    }

    public boolean enlistParticipant(Participant participant) {
        ATParticipant atParticipant = new ATParticipant(this.getATCoordinator(), participant);
        atParticipant.register();
        return true;
    }

    public void registerSynchronization(Synchronization synchronization) throws RollbackException, IllegalStateException, SystemException {
        this.txn.registerSynchronization(synchronization);
    }

    public void rollback() throws IllegalStateException, SystemException {
        this.txn.rollback();
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.txn.setRollbackOnly();
    }

    private Coordinator getATCoordinator() {
        return this.COORDINATOR;
    }

    public int getStatus() throws SystemException {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

