/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecryptedInputStream
extends FilterInputStream {
    private static final int SKIP_BUFFER_SIZE = 2048;
    private static byte[] skipBuffer;
    private StringBuilder startElement = new StringBuilder("<StartElement");
    private static final String endElement = "</StartElement>";
    private InputStream startIS = null;
    private InputStream endIS = new ByteArrayInputStream("</StartElement>".getBytes());

    public DecryptedInputStream(InputStream is, HashMap<String, String> parentNS) {
        super(is);
        Set<Map.Entry<String, String>> set = parentNS.entrySet();
        for (Map.Entry<String, String> entry : set) {
            if (!"".equals(entry.getKey())) {
                this.startElement.append(" xmlns:" + entry.getKey() + "=\"" + entry.getValue() + "\"");
                continue;
            }
            this.startElement.append(" xmlns=\"" + entry.getValue() + "\"");
        }
        this.startElement.append(" >");
        String startElem = this.startElement.toString();
        this.startIS = new ByteArrayInputStream(startElem.getBytes());
    }

    @Override
    public int read() throws IOException {
        int readVal = this.startIS.read();
        if (readVal != -1) {
            return readVal;
        }
        readVal = this.in.read();
        if (readVal != -1) {
            return readVal;
        }
        return this.endIS.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length - 1);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int readVal = this.read();
        if (readVal == -1) {
            return -1;
        }
        b[off] = (byte)readVal;
        for (i = 1; i < len && (readVal = this.read()) != -1; ++i) {
            if (b == null) continue;
            b[off + i] = (byte)readVal;
        }
        return i;
    }

    @Override
    public long skip(long n) throws IOException {
        int nr;
        long remaining = n;
        if (skipBuffer == null) {
            skipBuffer = new byte[2048];
        }
        byte[] localSkipBuffer = skipBuffer;
        if (n <= 0L) {
            return 0L;
        }
        while (remaining > 0L && (nr = this.read(localSkipBuffer, 0, (int)Math.min(2048L, remaining))) >= 0) {
            remaining -= (long)nr;
        }
        return n - remaining;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new IOException("mark/reset not supported");
    }

    @Override
    public void close() throws IOException {
        this.startIS.close();
        this.in.close();
        this.endIS.close();
    }
}

