/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.crypto.dsig;

import com.sun.xml.security.core.dsig.InclusiveNamespacesType;
import com.sun.xml.security.core.dsig.ObjectFactory;
import com.sun.xml.security.core.dsig.TransformType;
import com.sun.xml.ws.security.opt.crypto.dsig.ACOTransform;
import com.sun.xml.ws.security.opt.crypto.dsig.CanonicalizationMethod;
import com.sun.xml.ws.security.opt.crypto.dsig.Exc14nCanonicalizer;
import com.sun.xml.ws.security.opt.impl.dsig.ExcC14NParameterSpec;
import com.sun.xml.ws.security.opt.impl.dsig.StAXEnvelopedTransformWriter;
import com.sun.xml.ws.security.opt.impl.dsig.StAXSTRTransformWriter;
import com.sun.xml.ws.security.secext10.TransformationParametersType;
import com.sun.xml.wss.impl.c14n.StAXEXC14nCanonicalizerImpl;
import com.sun.xml.wss.logging.impl.opt.signature.LogStringsMessages;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.crypto.Data;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.stream.XMLStreamException;

@XmlRootElement(name="Transform", namespace="http://www.w3.org/2000/09/xmldsig#")
public class Transform
extends TransformType
implements javax.xml.crypto.dsig.Transform {
    @XmlTransient
    private static final Logger logger = Logger.getLogger("com.sun.xml.wss.logging.impl.opt.signature", "com.sun.xml.wss.logging.impl.opt.signature.LogStrings");
    @XmlTransient
    private AlgorithmParameterSpec algSpec = null;
    @XmlTransient
    private Exc14nCanonicalizer _exc14nTransform;
    @XmlTransient
    private String refId = "";

    public AlgorithmParameterSpec getParameterSpec() {
        return this.algSpec;
    }

    public void setParameterSpec(AlgorithmParameterSpec algSpec) {
        this.algSpec = algSpec;
    }

    public void setContent(List content) {
        this.content = content;
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext) throws TransformException {
        if (this.getAlgorithm() == "http://www.w3.org/2001/10/xml-exc-c14n#") {
            if (this._exc14nTransform == null) {
                this._exc14nTransform = new Exc14nCanonicalizer();
            }
            return this._exc14nTransform.transform(data, xMLCryptoContext);
        }
        if (this.getAlgorithm().equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) {
            return new StAXEnvelopedTransformWriter(data);
        }
        if (this.getAlgorithm().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
            return new StAXSTRTransformWriter(data, xMLCryptoContext, this.refId);
        }
        throw new UnsupportedOperationException("Algorithm Transform " + this.getAlgorithm() + " not supported yet");
    }

    public Data transform(Data data, XMLCryptoContext xMLCryptoContext, OutputStream outputStream) throws TransformException {
        if (this.getAlgorithm().equals("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform")) {
            JAXBElement el;
            TransformationParametersType tp;
            CanonicalizationMethod cm;
            String algo;
            Object ob;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStream fis = outputStream;
            if (logger.isLoggable(Level.FINEST)) {
                fis = bos;
            }
            StAXEXC14nCanonicalizerImpl _canonicalizer = null;
            if ((this.algSpec != null || this.content.size() > 0) && (ob = this.content.get(0)) instanceof JAXBElement && "http://www.w3.org/2001/10/xml-exc-c14n#".equals(algo = (cm = (CanonicalizationMethod)(tp = (TransformationParametersType)(el = (JAXBElement)ob).getValue()).getAny().get(0)).getAlgorithm())) {
                _canonicalizer = new StAXEXC14nCanonicalizerImpl();
                if (!logger.isLoggable(Level.FINEST)) {
                    _canonicalizer.setStream(outputStream);
                } else {
                    _canonicalizer.setStream(fis);
                }
            }
            StAXSTRTransformWriter strWriter = new StAXSTRTransformWriter(data, xMLCryptoContext, this.refId);
            try {
                strWriter.write(_canonicalizer);
            }
            catch (XMLStreamException ex) {
                throw new TransformException(ex);
            }
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, LogStringsMessages.WSS_1757_CANONICALIZED_TARGET_VALUE(bos.toString()));
                try {
                    outputStream.write(bos.toByteArray());
                    return null;
                }
                catch (IOException ex) {
                    throw new TransformException(ex);
                }
            }
            return null;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        OutputStream fis = outputStream;
        if (logger.isLoggable(Level.FINEST)) {
            fis = bos;
        }
        if (this.getAlgorithm().intern() == "http://www.w3.org/2001/10/xml-exc-c14n#".intern()) {
            if (this._exc14nTransform == null) {
                this._exc14nTransform = new Exc14nCanonicalizer();
                try {
                    this._exc14nTransform.init((TransformParameterSpec)this.algSpec);
                }
                catch (InvalidAlgorithmParameterException e) {
                    throw new TransformException(e);
                }
            }
            if (!logger.isLoggable(Level.FINEST)) {
                Data canData = this._exc14nTransform.transform(data, xMLCryptoContext, fis);
                this.setContentList();
                return canData;
            }
            this._exc14nTransform.transform(data, xMLCryptoContext, fis);
            this.setContentList();
            logger.log(Level.FINEST, LogStringsMessages.WSS_1757_CANONICALIZED_TARGET_VALUE(bos.toString()));
            try {
                outputStream.write(bos.toByteArray());
                return null;
            }
            catch (IOException ex) {
                throw new TransformException(ex);
            }
        }
        if (this.getAlgorithm().intern() == "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform") {
            ACOTransform acoTransform = new ACOTransform();
            return acoTransform.transform(data, xMLCryptoContext, fis);
        }
        if (this.getAlgorithm().intern() == "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Content-Signature-Transform" || this.getAlgorithm().intern() == "http://docs.oasis-open.org/wss/oasis-wss-SwAProfile-1.1#Attachment-Ciphertext-Transform") {
            // empty if block
        }
        throw new UnsupportedOperationException("Algorithm Transform " + this.getAlgorithm() + " not supported yet");
    }

    public boolean isFeatureSupported(String string2) {
        return false;
    }

    public void setReferenceId(String id) {
        this.refId = id;
    }

    private void setContentList() {
        if (this.algSpec != null) {
            this.content = this.setInclusiveNamespaces((ExcC14NParameterSpec)this.algSpec);
        }
    }

    private List setInclusiveNamespaces(ExcC14NParameterSpec spec) {
        ObjectFactory objFac = new ObjectFactory();
        InclusiveNamespacesType incList = objFac.createInclusiveNamespaces();
        List prefixList = spec.getPrefixList();
        for (int j = 0; j < prefixList.size(); ++j) {
            String prefix = (String)prefixList.get(j);
            incList.addToPrefixList(prefix);
        }
        JAXBElement<InclusiveNamespacesType> je = objFac.createInclusiveNamespaces(incList);
        ArrayList<JAXBElement<InclusiveNamespacesType>> contentList = new ArrayList<JAXBElement<InclusiveNamespacesType>>();
        contentList.add(je);
        return contentList;
    }
}

