/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.kerb;

import com.sun.xml.ws.security.kerb.Krb5MechFactory;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import sun.security.jgss.spi.GSSNameSpi;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.ServiceName;

public class Krb5NameElement
implements GSSNameSpi {
    private PrincipalName krb5PrincipalName;
    private String gssNameStr = null;
    private Oid gssNameType = null;
    private static String CHAR_ENCODING = "UTF-8";

    private Krb5NameElement(PrincipalName principalName, String gssNameStr, Oid gssNameType) {
        this.krb5PrincipalName = principalName;
        this.gssNameStr = gssNameStr;
        this.gssNameType = gssNameType;
    }

    static Krb5NameElement getInstance(String gssNameStr, Oid gssNameType) throws GSSException {
        PrincipalName principalName;
        if (gssNameType == null) {
            gssNameType = Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL;
        } else if (!(gssNameType.equals(GSSName.NT_USER_NAME) || gssNameType.equals(GSSName.NT_HOSTBASED_SERVICE) || gssNameType.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL) || gssNameType.equals(GSSName.NT_EXPORT_NAME))) {
            throw new GSSException(4, -1, gssNameType.toString() + " is an unsupported nametype");
        }
        try {
            if (gssNameType.equals(GSSName.NT_EXPORT_NAME) || gssNameType.equals(Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL)) {
                principalName = new PrincipalName(gssNameStr, 1);
            } else {
                String[] components = Krb5NameElement.getComponents(gssNameStr);
                if (gssNameType.equals(GSSName.NT_USER_NAME)) {
                    principalName = new PrincipalName(gssNameStr, 1);
                } else {
                    String hostName = null;
                    String service = components[0];
                    if (components.length >= 2) {
                        hostName = components[1];
                    }
                    String principal = Krb5NameElement.getHostBasedInstance(service, hostName);
                    principalName = new ServiceName(principal, 3);
                }
            }
        }
        catch (KrbException e) {
            throw new GSSException(3, -1, e.getMessage());
        }
        return new Krb5NameElement(principalName, gssNameStr, gssNameType);
    }

    static Krb5NameElement getInstance(PrincipalName principalName) {
        return new Krb5NameElement(principalName, principalName.getName(), Krb5MechFactory.NT_GSS_KRB5_PRINCIPAL);
    }

    private static String[] getComponents(String gssNameStr) throws GSSException {
        String[] retVal;
        int separatorPos = gssNameStr.lastIndexOf(64, gssNameStr.length());
        if (separatorPos > 0 && gssNameStr.charAt(separatorPos - 1) == '\\' && (separatorPos - 2 < 0 || gssNameStr.charAt(separatorPos - 2) != '\\')) {
            separatorPos = -1;
        }
        if (separatorPos > 0) {
            String serviceName = gssNameStr.substring(0, separatorPos);
            String hostName = gssNameStr.substring(separatorPos + 1);
            retVal = new String[]{serviceName, hostName};
        } else {
            retVal = new String[]{gssNameStr};
        }
        return retVal;
    }

    private static String getHostBasedInstance(String serviceName, String hostName) throws GSSException {
        StringBuffer temp = new StringBuffer(serviceName);
        try {
            if (hostName == null) {
                hostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        hostName = hostName.toLowerCase();
        temp = temp.append('/').append(hostName);
        return temp.toString();
    }

    public final PrincipalName getKrb5PrincipalName() {
        return this.krb5PrincipalName;
    }

    public boolean equals(GSSNameSpi other) throws GSSException {
        if (other == this) {
            return true;
        }
        if (other instanceof Krb5NameElement) {
            Krb5NameElement that = (Krb5NameElement)other;
            return this.krb5PrincipalName.getName().equals(that.krb5PrincipalName.getName());
        }
        return false;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        try {
            if (another instanceof Krb5NameElement) {
                return this.equals((Krb5NameElement)another);
            }
        }
        catch (GSSException gSSException) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return 629 + this.krb5PrincipalName.getName().hashCode();
    }

    public byte[] export() throws GSSException {
        byte[] retVal = null;
        try {
            retVal = this.krb5PrincipalName.getName().getBytes(CHAR_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return retVal;
    }

    public Oid getMechanism() {
        return Krb5MechFactory.GSS_KRB5_MECH_OID;
    }

    public String toString() {
        return this.gssNameStr;
    }

    public Oid getGSSNameType() {
        return this.gssNameType;
    }

    public Oid getStringNameType() {
        return this.gssNameType;
    }

    public boolean isAnonymousName() {
        return this.gssNameType.equals(GSSName.NT_ANONYMOUS);
    }

    public Provider getProvider() {
        return Krb5MechFactory.PROVIDER;
    }
}

