/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.protocol;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import javax.xml.ws.EndpointReference;

public class CreateSequenceResponseData {
    @NotNull
    private final String sequenceId;
    private final long duration;
    @Nullable
    private final EndpointReference acceptedSequenceAcksTo;
    private final Sequence.IncompleteSequenceBehavior incompleteSequenceBehavior;

    public static Builder getBuilder(String sequenceId) {
        return new Builder(sequenceId);
    }

    private CreateSequenceResponseData(@NotNull String sequenceId, long expirationTime, @Nullable EndpointReference acceptedSequenceAcksTo, Sequence.IncompleteSequenceBehavior incompleteSequenceBehavior) {
        this.sequenceId = sequenceId;
        this.duration = expirationTime;
        this.acceptedSequenceAcksTo = acceptedSequenceAcksTo;
        this.incompleteSequenceBehavior = incompleteSequenceBehavior;
    }

    @Nullable
    public EndpointReference getAcceptedSequenceAcksTo() {
        return this.acceptedSequenceAcksTo;
    }

    public long getDuration() {
        return this.duration;
    }

    public boolean doesNotExpire() {
        return this.duration == -1L;
    }

    @NotNull
    public String getSequenceId() {
        return this.sequenceId;
    }

    public Sequence.IncompleteSequenceBehavior getIncompleteSequenceBehavior() {
        return this.incompleteSequenceBehavior;
    }

    public static class Builder {
        @NotNull
        private final String sequenceId;
        private long duration;
        @Nullable
        private EndpointReference acceptedSequenceAcksTo;
        private Sequence.IncompleteSequenceBehavior incompleteSequenceBehavior;

        private Builder(String sequenceId) {
            this.sequenceId = sequenceId;
            this.duration = -1L;
            this.incompleteSequenceBehavior = Sequence.IncompleteSequenceBehavior.getDefault();
        }

        public Builder acceptedSequenceAcksTo(EndpointReference acceptedSequenceAcksTo) {
            this.acceptedSequenceAcksTo = acceptedSequenceAcksTo;
            return this;
        }

        public Builder duration(long duration) {
            this.duration = duration;
            return this;
        }

        public Builder incompleteSequenceBehavior(Sequence.IncompleteSequenceBehavior value) {
            this.incompleteSequenceBehavior = value;
            return this;
        }

        public CreateSequenceResponseData build() {
            return new CreateSequenceResponseData(this.sequenceId, this.duration, this.acceptedSequenceAcksTo, this.incompleteSequenceBehavior);
        }
    }
}

