/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.wsdl.parser;

import com.sun.xml.rpc.util.xml.XmlUtil;
import com.sun.xml.rpc.wsdl.document.Definitions;
import com.sun.xml.rpc.wsdl.document.Import;
import com.sun.xml.rpc.wsdl.document.WSDLDocument;
import com.sun.xml.rpc.wsdl.document.schema.Schema;
import com.sun.xml.rpc.wsdl.document.schema.SchemaConstants;
import com.sun.xml.rpc.wsdl.document.schema.SchemaElement;
import com.sun.xml.rpc.wsdl.framework.Extensible;
import com.sun.xml.rpc.wsdl.framework.Extension;
import com.sun.xml.rpc.wsdl.framework.ParserContext;
import com.sun.xml.rpc.wsdl.framework.WriterContext;
import com.sun.xml.rpc.wsdl.parser.ExtensionHandler;
import com.sun.xml.rpc.wsdl.parser.SchemaParser;
import com.sun.xml.rpc.wsdl.parser.WSDLParser;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WSDLUtil
implements com.sun.xml.rpc.spi.tools.WSDLUtil {
    public void getRelativeImports(URL wsdlURL, Collection wsdlRelativeImports, Collection schemaRelativeImports) throws IOException {
        BufferedInputStream wsdlInputStream = new BufferedInputStream(wsdlURL.openStream());
        InputSource wsdlDocumentSource = new InputSource(wsdlInputStream);
        WSDLParserOverride wsdlParser = new WSDLParserOverride();
        wsdlParser.setFollowImports(false);
        WSDLDocument wsdlDoc = wsdlParser.parse(wsdlDocumentSource);
        Iterator iter = wsdlDoc.getDefinitions().imports();
        while (iter.hasNext()) {
            Import next = (Import)iter.next();
            String location = next.getLocation();
            if (location.indexOf(":") != -1) continue;
            wsdlRelativeImports.add(next);
        }
        Collection schemaImports = wsdlParser.getSchemaImports();
        for (Import next : schemaImports) {
            String location = next.getLocation();
            if (location.indexOf(":") != -1) continue;
            schemaRelativeImports.add(next);
        }
        ((InputStream)wsdlInputStream).close();
    }

    private static class SchemaParserOverride
    extends SchemaParser {
        private Collection imports = new HashSet();

        private SchemaParserOverride() {
        }

        public Collection getImports() {
            return this.imports;
        }

        protected void processImports(ParserContext context, InputSource src, Schema schema) {
            Iterator iter = schema.getContent().children();
            while (iter.hasNext()) {
                SchemaElement child = (SchemaElement)iter.next();
                if (!child.getQName().equals(SchemaConstants.QNAME_IMPORT)) continue;
                String location = child.getValueOfAttributeOrNull("schemaLocation");
                String namespace = child.getValueOfAttributeOrNull("namespace");
                if (location == null || namespace == null) continue;
                Import schemaImport = new Import();
                schemaImport.setLocation(location);
                schemaImport.setNamespace(namespace);
                this.imports.add(schemaImport);
            }
        }
    }

    private static class SchemaExtensionHandlerOverride
    extends ExtensionHandler {
        private SchemaParserOverride parser = new SchemaParserOverride();

        public Collection getImports() {
            return this.parser.getImports();
        }

        public String getNamespaceURI() {
            return "http://www.w3.org/2001/XMLSchema";
        }

        public boolean doHandleExtension(ParserContext context, Extensible parent, Element e) {
            if (XmlUtil.matchesTagNS(e, SchemaConstants.QNAME_SCHEMA)) {
                parent.addExtension(this.parser.parseSchema(context, e, null));
                return true;
            }
            return false;
        }

        public void doHandleExtension(WriterContext context, Extension extension) throws IOException {
            throw new IllegalArgumentException("unsupported operation");
        }
    }

    private static class WSDLParserOverride
    extends WSDLParser {
        private SchemaExtensionHandlerOverride schemaHandler = new SchemaExtensionHandlerOverride();

        public WSDLParserOverride() {
            this.register(this.schemaHandler);
        }

        public Collection getSchemaImports() {
            return this.schemaHandler.getImports();
        }

        protected Definitions parseDefinitions(ParserContext context, InputSource source, String expectedTargetNamespaceURI) {
            Definitions definitions = this.parseDefinitionsNoImport(context, source, expectedTargetNamespaceURI);
            return definitions;
        }
    }
}

