/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.spi;

import com.sun.xml.rpc.spi.runtime.ClientTransportFactory;
import com.sun.xml.rpc.spi.runtime.Implementor;
import com.sun.xml.rpc.spi.runtime.ImplementorCache;
import com.sun.xml.rpc.spi.runtime.RuntimeEndpointInfo;
import com.sun.xml.rpc.spi.runtime.SOAPMessageContext;
import com.sun.xml.rpc.spi.runtime.ServletDelegate;
import com.sun.xml.rpc.spi.runtime.Tie;
import com.sun.xml.rpc.spi.tools.CompileTool;
import com.sun.xml.rpc.spi.tools.Configuration;
import com.sun.xml.rpc.spi.tools.HandlerInfo;
import com.sun.xml.rpc.spi.tools.J2EEModelInfo;
import com.sun.xml.rpc.spi.tools.ModelFileModelInfo;
import com.sun.xml.rpc.spi.tools.Names;
import com.sun.xml.rpc.spi.tools.NamespaceMappingInfo;
import com.sun.xml.rpc.spi.tools.NamespaceMappingRegistryInfo;
import com.sun.xml.rpc.spi.tools.NoMetadataModelInfo;
import com.sun.xml.rpc.spi.tools.ProcessorEnvironment;
import com.sun.xml.rpc.spi.tools.WSDLParser;
import com.sun.xml.rpc.spi.tools.WSDLUtil;
import com.sun.xml.rpc.spi.tools.XMLModelFileFilter;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public abstract class JaxRpcObjectFactory {
    private static JaxRpcObjectFactory factory;
    private static String DEFAULT_JAXRPC_OBJECT_FACTORY;
    private static String JAXRPC_FACTORY_PROPERTY;

    private static Object newInstance(String className, ClassLoader classLoader) {
        try {
            Class<?> spiClass = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return spiClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static JaxRpcObjectFactory newInstance() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            String systemProp = System.getProperty(JAXRPC_FACTORY_PROPERTY);
            if (systemProp != null) {
                return (JaxRpcObjectFactory)JaxRpcObjectFactory.newInstance(systemProp, classLoader);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String serviceId = "META-INF/services/" + JAXRPC_FACTORY_PROPERTY;
        try {
            InputStream is = null;
            is = classLoader == null ? ClassLoader.getSystemResourceAsStream(serviceId) : classLoader.getResourceAsStream(serviceId);
            if (is != null) {
                BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                String factoryClassName = rd.readLine();
                rd.close();
                if (factoryClassName != null && !"".equals(factoryClassName)) {
                    return (JaxRpcObjectFactory)JaxRpcObjectFactory.newInstance(factoryClassName, classLoader);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (JaxRpcObjectFactory)JaxRpcObjectFactory.newInstance(DEFAULT_JAXRPC_OBJECT_FACTORY, classLoader);
    }

    public abstract ModelFileModelInfo createModelFileModelInfo();

    public abstract NoMetadataModelInfo createNoMetadataModelInfo();

    public abstract J2EEModelInfo createJ2EEModelInfo(URL var1) throws Exception;

    public abstract HandlerInfo createHandlerInfo();

    public abstract NamespaceMappingRegistryInfo createNamespaceMappingRegistryInfo();

    public abstract NamespaceMappingInfo createNamespaceMappingInfo(String var1, String var2);

    public abstract Configuration createConfiguration(ProcessorEnvironment var1);

    public abstract SOAPMessageContext createSOAPMessageContext();

    public abstract Implementor createImplementor(ServletContext var1, Tie var2);

    public abstract RuntimeEndpointInfo createRuntimeEndpointInfo();

    public abstract ClientTransportFactory createClientTransportFactory(int var1, OutputStream var2);

    public abstract CompileTool createCompileTool(OutputStream var1, String var2);

    public abstract XMLModelFileFilter createXMLModelFileFilter();

    public abstract ImplementorCache createImplementorCache(ServletConfig var1);

    public abstract ServletDelegate createServletDelegate();

    public abstract Names createNames();

    public abstract WSDLUtil createWSDLUtil();

    public abstract WSDLParser createWSDLParser();

    static {
        DEFAULT_JAXRPC_OBJECT_FACTORY = "com.sun.xml.rpc.util.JaxRpcObjectFactoryImpl";
        JAXRPC_FACTORY_PROPERTY = "javax.xml.rpc.spi.JaxRpcObjectFactory";
    }
}

