// Listing 8.2: PatientDatabaseDAO.java

package com.oreilly.patterns.chapter8;

import com.oreilly.patterns.chapter7.PatientDTO;
import com.oreilly.patterns.chapter7.Address;

import java.util.*;
import java.sql.*;
import javax.sql.*;
import javax.naming.*;

public class PatientDatabaseDAO implements PatientDAO  {

  public PatientDTO findPatient(long pat_no)  {
  
    Connection con = null;
    PreparedStatement ps = null;
    ResultSet rs = null;
    PatientDTO patient = null;
    
    try {
      con = getConnection(); // lokalna metoda wyszukiwania przez JNDI
      ps = con.prepareStatement("select * from patient where pat_no = ?");
      ps.setLong(1, pat_no);
      rs = ps.executeQuery();

      if(!rs.next())
       return null;

      patient = new PatientDTO();    
      patient.pat_no = pat_no;
      patient.fname = rs.getString("fname");
      patient.lname= rs.getString("lname");
      ps.close();
      rs.close();
      
      ps = con.prepareStatement(
        "select * from patient_address where pat_no = ? and address_label in " +
        "('Home', 'Work')");
        
      ps.setLong(1, pat_no);
      rs = ps.executeQuery();
      // aduje kady adres
      while(rs.next()) {
        String addrType = rs.getString("ADDRESS_LABEL");
        Address addr = new Address();
        addr.addressType = addrType;
        addr.address1 = rs.getString("addr1");
        addr.address2 = rs.getString("addr2");
        addr.city = rs.getString("city");
        addr.province = rs.getString("province");
        addr.postcode = rs.getString("postcode");
        patient.addresses.add(addr);
      }
    } catch (SQLException e) {
      e.printStackTrace();
    } finally {
      try { 
        if(rs != null) rs.close();
        if(ps != null) ps.close();
        if(con != null) con.close();
      } catch (SQLException e) {}
    }
    
    return patient;
  }

  public void savePatient(PatientDTO patient) {
    // tutaj kod odpowiedzialny za trwao
  } 
  
  public PatientDTO createPatient(PatientDTO patient) {
    // tutaj kod odpowiedzialny za tworzenie
    return null;
  }
  
  private Connection getConnection() throws SQLException {
    try {
      Context jndiContext = new InitialContext();
      DataSource ds = (DataSource)jndiContext.lookup("java:comp/env/jdbc/DataChapterDS");
      return ds.getConnection();
    } catch (NamingException ne) {
        throw new SQLException (ne.getMessage());
    }
  }
}
